/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.bukkit;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.CommandManager;
import ca.stellardrift.permissionsex.ext.commandframework.CommandTree;
import ca.stellardrift.permissionsex.ext.commandframework.brigadier.BrigadierManagerHolder;
import ca.stellardrift.permissionsex.ext.commandframework.brigadier.CloudBrigadierManager;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.BukkitCaptionRegistryFactory;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.BukkitCommandMeta;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.BukkitCommandMetaBuilder;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.BukkitCommandPreprocessor;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.BukkitPluginRegistrationHandler;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.BukkitSynchronizer;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.CloudBukkitCapabilities;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.CloudBukkitListener;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.CloudCommodoreManager;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.arguments.selector.MultipleEntitySelector;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.arguments.selector.MultiplePlayerSelector;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.arguments.selector.SingleEntitySelector;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.arguments.selector.SinglePlayerSelector;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.parsers.EnchantmentArgument;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.parsers.MaterialArgument;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.parsers.OfflinePlayerArgument;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.parsers.PlayerArgument;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.parsers.WorldArgument;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.parsers.location.LocationArgument;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.parsers.selector.MultipleEntitySelectorArgument;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.parsers.selector.MultiplePlayerSelectorArgument;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.parsers.selector.SingleEntitySelectorArgument;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.parsers.selector.SinglePlayerSelectorArgument;
import ca.stellardrift.permissionsex.ext.commandframework.execution.CommandExecutionCoordinator;
import ca.stellardrift.permissionsex.ext.commandframework.tasks.TaskFactory;
import ca.stellardrift.permissionsex.ext.commandframework.tasks.TaskRecipe;
import ca.stellardrift.permissionsex.ext.geantyref.TypeToken;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BukkitCommandManager<C>
extends CommandManager<C>
implements BrigadierManagerHolder<C> {
    private static final int VERSION_RADIX = 10;
    private static final int BRIGADIER_MINIMUM_VERSION = 13;
    private static final int PAPER_BRIGADIER_VERSION = 15;
    private static final int ASYNC_TAB_MINIMUM_VERSION = 12;
    private final Plugin owningPlugin;
    private final int minecraftVersion;
    private final boolean paper;
    private final Function<CommandSender, C> commandSenderMapper;
    private final Function<C, CommandSender> backwardsCommandSenderMapper;
    private final TaskFactory taskFactory;
    private boolean splitAliases = false;

    public BukkitCommandManager(@NonNull Plugin owningPlugin, @NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> commandExecutionCoordinator, @NonNull Function<@NonNull CommandSender, @NonNull C> commandSenderMapper, @NonNull Function<@NonNull C, @NonNull CommandSender> backwardsCommandSenderMapper) throws Exception {
        super(commandExecutionCoordinator, new BukkitPluginRegistrationHandler());
        ((BukkitPluginRegistrationHandler)this.getCommandRegistrationHandler()).initialize(this);
        this.owningPlugin = owningPlugin;
        this.commandSenderMapper = commandSenderMapper;
        this.backwardsCommandSenderMapper = backwardsCommandSenderMapper;
        BukkitSynchronizer bukkitSynchronizer = new BukkitSynchronizer(owningPlugin);
        this.taskFactory = new TaskFactory(bukkitSynchronizer);
        int version = -1;
        try {
            Matcher matcher = Pattern.compile("\\(MC: (\\d)\\.(\\d+)\\.?(\\d+?)?\\)").matcher(Bukkit.getVersion());
            if (matcher.find()) {
                version = Integer.parseInt(matcher.toMatchResult().group(2), 10);
            }
        }
        catch (Exception e) {
            this.owningPlugin.getLogger().severe("Failed to determine Minecraft version for cloud Bukkit capability detection");
        }
        this.minecraftVersion = version;
        boolean paper = false;
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            paper = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.paper = paper;
        this.registerCommandPreProcessor(new BukkitCommandPreprocessor(this));
        this.getParserRegistry().registerParserSupplier(TypeToken.get(World.class), parserParameters -> new WorldArgument.WorldParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(Material.class), parserParameters -> new MaterialArgument.MaterialParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(Player.class), parserParameters -> new PlayerArgument.PlayerParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(OfflinePlayer.class), parserParameters -> new OfflinePlayerArgument.OfflinePlayerParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(Enchantment.class), parserParameters -> new EnchantmentArgument.EnchantmentParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(Location.class), parserParameters -> new LocationArgument.LocationParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(SingleEntitySelector.class), parserParameters -> new SingleEntitySelectorArgument.SingleEntitySelectorParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(SinglePlayerSelector.class), parserParameters -> new SinglePlayerSelectorArgument.SinglePlayerSelectorParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(MultipleEntitySelector.class), parserParameters -> new MultipleEntitySelectorArgument.MultipleEntitySelectorParser());
        this.getParserRegistry().registerParserSupplier(TypeToken.get(MultiplePlayerSelector.class), parserParameters -> new MultiplePlayerSelectorArgument.MultiplePlayerSelectorParser());
        this.owningPlugin.getServer().getPluginManager().registerEvents(new CloudBukkitListener(this), this.owningPlugin);
        this.setCaptionRegistry(new BukkitCaptionRegistryFactory().create());
    }

    public @NonNull TaskRecipe taskRecipe() {
        return this.taskFactory.recipe();
    }

    public @NonNull Plugin getOwningPlugin() {
        return this.owningPlugin;
    }

    @Override
    public @NonNull BukkitCommandMeta createDefaultCommandMeta() {
        return BukkitCommandMetaBuilder.builder().withDescription("").build();
    }

    public final @NonNull Function<@NonNull CommandSender, @NonNull C> getCommandSenderMapper() {
        return this.commandSenderMapper;
    }

    @Override
    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        if (permission.isEmpty()) {
            return true;
        }
        return this.backwardsCommandSenderMapper.apply(sender).hasPermission(permission);
    }

    protected final boolean getSplitAliases() {
        return this.splitAliases;
    }

    protected final void setSplitAliases(boolean value) {
        this.requireState(CommandManager.RegistrationState.BEFORE_REGISTRATION);
        this.splitAliases = value;
    }

    protected final void checkBrigadierCompatibility() throws BrigadierFailureException {
        if (!this.queryCapability(CloudBukkitCapabilities.BRIGADIER)) {
            throw new BrigadierFailureException(BrigadierFailureReason.VERSION_TOO_LOW, (Throwable)new IllegalArgumentException("Version: " + this.minecraftVersion));
        }
    }

    public final boolean queryCapability(@NonNull CloudBukkitCapabilities capability) {
        return this.queryCapabilities().contains((Object)capability);
    }

    public final @NonNull Set<@NonNull CloudBukkitCapabilities> queryCapabilities() {
        if (this.paper) {
            if (this.minecraftVersion >= 12) {
                if (this.minecraftVersion >= 15) {
                    return EnumSet.of(CloudBukkitCapabilities.NATIVE_BRIGADIER, CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION, CloudBukkitCapabilities.BRIGADIER);
                }
                if (this.minecraftVersion >= 13) {
                    return EnumSet.of(CloudBukkitCapabilities.COMMODORE_BRIGADIER, CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION, CloudBukkitCapabilities.BRIGADIER);
                }
                return EnumSet.of(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION);
            }
        } else if (this.minecraftVersion >= 13) {
            return EnumSet.of(CloudBukkitCapabilities.COMMODORE_BRIGADIER, CloudBukkitCapabilities.BRIGADIER);
        }
        return EnumSet.noneOf(CloudBukkitCapabilities.class);
    }

    public void registerBrigadier() throws BrigadierFailureException {
        this.requireState(CommandManager.RegistrationState.BEFORE_REGISTRATION);
        this.checkBrigadierCompatibility();
        try {
            CloudCommodoreManager cloudCommodoreManager = new CloudCommodoreManager(this);
            cloudCommodoreManager.initialize(this);
            this.setCommandRegistrationHandler(cloudCommodoreManager);
            this.setSplitAliases(true);
        }
        catch (Throwable e) {
            throw new BrigadierFailureException(BrigadierFailureReason.COMMODORE_NOT_PRESENT, e);
        }
    }

    @Override
    public @Nullable CloudBrigadierManager<C, ?> brigadierManager() {
        if (this.getCommandRegistrationHandler() instanceof CloudCommodoreManager) {
            return ((CloudCommodoreManager)this.getCommandRegistrationHandler()).brigadierManager();
        }
        return null;
    }

    public final @NonNull String stripNamespace(@NonNull String command) {
        String namespace;
        @NonNull String input = command.charAt(0) == '/' ? command.substring(1) : command;
        if (input.startsWith(namespace = String.format("%s:", this.getOwningPlugin().getName().toLowerCase()))) {
            input = input.substring(namespace.length());
        }
        return input;
    }

    public final @NonNull Function<@NonNull C, @NonNull CommandSender> getBackwardsCommandSenderMapper() {
        return this.backwardsCommandSenderMapper;
    }

    final void lockIfBrigadierCapable() {
        if (this.minecraftVersion >= 13) {
            this.transitionOrThrow(CommandManager.RegistrationState.REGISTERING, CommandManager.RegistrationState.AFTER_REGISTRATION);
        }
    }

    public static final class BrigadierFailureException
    extends IllegalStateException {
        private static final long serialVersionUID = 7816660840063155703L;
        private final BrigadierFailureReason reason;

        public BrigadierFailureException(@NonNull BrigadierFailureReason reason) {
            this.reason = reason;
        }

        public BrigadierFailureException(@NonNull BrigadierFailureReason reason, @NonNull Throwable cause) {
            super(cause);
            this.reason = reason;
        }

        public @NonNull BrigadierFailureReason getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return String.format("Could not initialize Brigadier mappings. Reason: %s (%s)", this.reason.name().toLowerCase().replace("_", " "), this.getCause() == null ? "" : this.getCause().getMessage());
        }
    }

    public static enum BrigadierFailureReason {
        COMMODORE_NOT_PRESENT,
        VERSION_TOO_LOW,
        PAPER_BRIGADIER_INITIALIZATION_FAILURE;

    }
}

