/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.bukkit;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.BukkitCommandManager;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.BukkitPluginRegistrationHandler;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.server.TabCompleteEvent;

final class CloudBukkitListener<C>
implements Listener {
    private final BukkitCommandManager<C> bukkitCommandManager;

    CloudBukkitListener(@NonNull BukkitCommandManager<C> bukkitCommandManager) {
        this.bukkitCommandManager = bukkitCommandManager;
    }

    @EventHandler
    void onTabCompletion(@NonNull TabCompleteEvent event) {
        String commandLabel;
        if (event.getBuffer().isEmpty() || !event.getBuffer().startsWith("/")) {
            return;
        }
        BukkitPluginRegistrationHandler bukkitPluginRegistrationHandler = (BukkitPluginRegistrationHandler)this.bukkitCommandManager.getCommandRegistrationHandler();
        if (!bukkitPluginRegistrationHandler.isRecognized(commandLabel = event.getBuffer().substring(1).split(" ")[0])) {
            return;
        }
        CommandSender sender = event.getSender();
        C cloudSender = this.bukkitCommandManager.getCommandSenderMapper().apply(sender);
        String inputBuffer = this.bukkitCommandManager.stripNamespace(event.getBuffer());
        ArrayList<String> suggestions = new ArrayList<String>(this.bukkitCommandManager.suggest(cloudSender, inputBuffer));
        event.setCompletions(suggestions);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    void onPlayerLogin(@NonNull PlayerLoginEvent event) {
        this.bukkitCommandManager.lockIfBrigadierCapable();
    }
}

