/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.captions;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.commandframework.captions.Caption;
import ca.stellardrift.permissionsex.ext.commandframework.captions.FactoryDelegatingCaptionRegistry;
import ca.stellardrift.permissionsex.ext.commandframework.captions.StandardCaptionKeys;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class SimpleCaptionRegistry<C>
implements FactoryDelegatingCaptionRegistry<C> {
    public static final String ARGUMENT_PARSE_FAILURE_NO_INPUT_PROVIDED = "No input was provided";
    public static final String ARGUMENT_PARSE_FAILURE_BOOLEAN = "Could not parse boolean from '{input}'";
    public static final String ARGUMENT_PARSE_FAILURE_NUMBER = "'{input}' is not a valid number in the range {min} to {max}";
    public static final String ARGUMENT_PARSE_FAILURE_CHAR = "'{input}' is not a valid character";
    public static final String ARGUMENT_PARSE_FAILURE_ENUM = "'{input}' is not one of the following: {acceptableValues}";
    public static final String ARGUMENT_PARSE_FAILURE_STRING = "'{input}' is not a valid string of type {stringMode}";
    public static final String ARGUMENT_PARSE_FAILURE_UUID = "'{input}' is not a valid UUID";
    public static final String ARGUMENT_PARSE_FAILURE_FLAG_UNKNOWN_FLAG = "Unknown flag '{flag}'";
    public static final String ARGUMENT_PARSE_FAILURE_FLAG_DUPLICATE_FLAG = "Duplicate flag '{flag}'";
    public static final String ARGUMENT_PARSE_FAILURE_FLAG_NO_FLAG_STARTED = "No flag started. Don't know what to do with '{input}'";
    public static final String ARGUMENT_PARSE_FAILURE_FLAG_MISSING_ARGUMENT = "Missing argument for '{flag}'";
    public static final String ARGUMENT_PARSE_FAILURE_COLOR = "'{input}' is not a valid color";
    private final Map<Caption, BiFunction<Caption, C, String>> messageFactories = new HashMap<Caption, BiFunction<Caption, C, String>>();

    protected SimpleCaptionRegistry() {
        this.registerMessageFactory(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_NO_INPUT_PROVIDED, (caption, sender) -> ARGUMENT_PARSE_FAILURE_NO_INPUT_PROVIDED);
        this.registerMessageFactory(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_BOOLEAN, (caption, sender) -> ARGUMENT_PARSE_FAILURE_BOOLEAN);
        this.registerMessageFactory(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_NUMBER, (caption, sender) -> ARGUMENT_PARSE_FAILURE_NUMBER);
        this.registerMessageFactory(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_CHAR, (caption, sender) -> ARGUMENT_PARSE_FAILURE_CHAR);
        this.registerMessageFactory(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_ENUM, (caption, sender) -> ARGUMENT_PARSE_FAILURE_ENUM);
        this.registerMessageFactory(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_STRING, (caption, sender) -> ARGUMENT_PARSE_FAILURE_STRING);
        this.registerMessageFactory(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_UUID, (caption, sender) -> ARGUMENT_PARSE_FAILURE_UUID);
        this.registerMessageFactory(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_FLAG_UNKNOWN_FLAG, (caption, sender) -> ARGUMENT_PARSE_FAILURE_FLAG_UNKNOWN_FLAG);
        this.registerMessageFactory(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_FLAG_DUPLICATE_FLAG, (caption, sender) -> ARGUMENT_PARSE_FAILURE_FLAG_DUPLICATE_FLAG);
        this.registerMessageFactory(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_FLAG_NO_FLAG_STARTED, (caption, sender) -> ARGUMENT_PARSE_FAILURE_FLAG_NO_FLAG_STARTED);
        this.registerMessageFactory(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_FLAG_MISSING_ARGUMENT, (caption, sender) -> ARGUMENT_PARSE_FAILURE_FLAG_MISSING_ARGUMENT);
        this.registerMessageFactory(StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_COLOR, (caption, sender) -> ARGUMENT_PARSE_FAILURE_COLOR);
    }

    @Override
    public final @NonNull String getCaption(@NonNull Caption caption, @NonNull C sender) {
        BiFunction<Caption, C, String> messageFactory = this.messageFactories.get(caption);
        if (messageFactory == null) {
            throw new IllegalArgumentException(String.format("There is no caption stored with key '%s'", caption));
        }
        return messageFactory.apply(caption, sender);
    }

    @Override
    public final void registerMessageFactory(@NonNull Caption caption, @NonNull BiFunction<Caption, C, String> messageFactory) {
        this.messageFactories.put(caption, messageFactory);
    }
}

