/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.exceptions;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import java.util.Iterator;
import java.util.List;

public final class AmbiguousNodeException
extends IllegalStateException {
    private static final long serialVersionUID = -200207173805584709L;
    private final CommandArgument<?, ?> parentNode;
    private final CommandArgument<?, ?> ambiguousNode;
    private final List<CommandArgument<?, ?>> children;

    public AmbiguousNodeException(@Nullable CommandArgument<?, ?> parentNode, @NonNull CommandArgument<?, ?> ambiguousNode, @NonNull List<@NonNull CommandArgument<?, ?>> children) {
        this.parentNode = parentNode;
        this.ambiguousNode = ambiguousNode;
        this.children = children;
    }

    public @Nullable CommandArgument<?, ?> getParentNode() {
        return this.parentNode;
    }

    public @NonNull CommandArgument<?, ?> getAmbiguousNode() {
        return this.ambiguousNode;
    }

    public @NonNull List<@NonNull CommandArgument<?, ?>> getChildren() {
        return this.children;
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder("Ambiguous Node: ").append(this.ambiguousNode.getName()).append(" cannot be added as a child to ").append(this.parentNode == null ? "<root>" : this.parentNode.getName()).append(" (All children: ");
        Iterator<CommandArgument<?, ?>> childIterator = this.children.iterator();
        while (childIterator.hasNext()) {
            stringBuilder.append(childIterator.next().getName());
            if (!childIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append(")").toString();
    }
}

