/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.exceptions;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.CommandParseException;
import java.util.List;

public final class NoSuchCommandException
extends CommandParseException {
    private static final long serialVersionUID = -7775865652882764771L;
    private final String suppliedCommand;

    public NoSuchCommandException(@NonNull Object commandSender, @NonNull List<CommandArgument<?, ?>> currentChain, @NonNull String command) {
        super(commandSender, currentChain);
        this.suppliedCommand = command;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        for (CommandArgument<?, ?> commandArgument : this.getCurrentChain()) {
            if (commandArgument == null) continue;
            builder.append(" ").append(commandArgument.getName());
        }
        return String.format("Unrecognized command input '%s' following chain%s", this.suppliedCommand, builder.toString());
    }

    public @NonNull String getSuppliedCommand() {
        return this.suppliedCommand;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        return this;
    }
}

