/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.execution;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.Command;
import ca.stellardrift.permissionsex.ext.commandframework.CommandTree;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.CommandExecutionException;
import ca.stellardrift.permissionsex.ext.commandframework.execution.CommandResult;
import ca.stellardrift.permissionsex.ext.commandframework.services.State;
import ca.stellardrift.permissionsex.ext.commandframework.types.tuples.Pair;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public abstract class CommandExecutionCoordinator<C> {
    private final CommandTree<C> commandTree;

    protected CommandExecutionCoordinator(@NonNull CommandTree<C> commandTree) {
        this.commandTree = commandTree;
    }

    public static <C> @NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> simpleCoordinator() {
        return x$0 -> new SimpleCoordinator((CommandTree)x$0);
    }

    public abstract @NonNull CompletableFuture<CommandResult<C>> coordinateExecution(@NonNull CommandContext<C> var1, @NonNull Queue<@NonNull String> var2);

    protected @NonNull CommandTree<C> getCommandTree() {
        return this.commandTree;
    }

    public static final class SimpleCoordinator<C>
    extends CommandExecutionCoordinator<C> {
        private SimpleCoordinator(@NonNull CommandTree<C> commandTree) {
            super(commandTree);
        }

        @Override
        public @NonNull CompletableFuture<CommandResult<C>> coordinateExecution(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> input) {
            CompletableFuture<CommandResult<C>> completableFuture;
            block7: {
                completableFuture = new CompletableFuture<CommandResult<C>>();
                try {
                    @NonNull Pair<@Nullable Command<C>, @Nullable Exception> pair = this.getCommandTree().parse(commandContext, input);
                    if (pair.getSecond() != null) {
                        completableFuture.completeExceptionally(pair.getSecond());
                        break block7;
                    }
                    Command command = Objects.requireNonNull(pair.getFirst());
                    if (this.getCommandTree().getCommandManager().postprocessContext(commandContext, command) == State.ACCEPTED) {
                        try {
                            command.getCommandExecutionHandler().execute(commandContext);
                        }
                        catch (CommandExecutionException exception) {
                            completableFuture.completeExceptionally(exception);
                        }
                        catch (Exception exception) {
                            completableFuture.completeExceptionally(new CommandExecutionException(exception));
                        }
                    }
                    completableFuture.complete(new CommandResult<C>(commandContext));
                }
                catch (Exception e) {
                    completableFuture.completeExceptionally(e);
                }
            }
            return completableFuture;
        }
    }
}

