/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.extra.confirmation;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.commandframework.CommandManager;
import ca.stellardrift.permissionsex.ext.commandframework.execution.CommandExecutionHandler;
import ca.stellardrift.permissionsex.ext.commandframework.execution.postprocessor.CommandPostprocessingContext;
import ca.stellardrift.permissionsex.ext.commandframework.execution.postprocessor.CommandPostprocessor;
import ca.stellardrift.permissionsex.ext.commandframework.meta.CommandMeta;
import ca.stellardrift.permissionsex.ext.commandframework.meta.SimpleCommandMeta;
import ca.stellardrift.permissionsex.ext.commandframework.services.types.ConsumerService;
import ca.stellardrift.permissionsex.ext.commandframework.types.tuples.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class CommandConfirmationManager<C> {
    @Deprecated
    public static final String CONFIRMATION_REQUIRED_META = "__REQUIRE_CONFIRMATION__";
    private static final CommandMeta.Key<String> LEGACY_CONFIRMATION_META = CommandMeta.Key.of(String.class, "__REQUIRE_CONFIRMATION__");
    public static final CommandMeta.Key<Boolean> META_CONFIRMATION_REQUIRED = CommandMeta.Key.of(Boolean.class, "cloud:require_confirmation", meta -> meta.get(LEGACY_CONFIRMATION_META).map(Boolean::valueOf).orElse(null));
    private static final int MAXIMUM_PENDING_SIZE = 100;
    private final Consumer<CommandPostprocessingContext<C>> notifier;
    private final Consumer<C> errorNotifier;
    private final Map<C, Pair<CommandPostprocessingContext<C>, Long>> pendingCommands;
    private final long timeoutMillis;

    public CommandConfirmationManager(long timeout, @NonNull TimeUnit timeoutTimeUnit, @NonNull Consumer<@NonNull CommandPostprocessingContext<C>> notifier, @NonNull Consumer<@NonNull C> errorNotifier) {
        this.notifier = notifier;
        this.errorNotifier = errorNotifier;
        this.pendingCommands = new LinkedHashMap<C, Pair<CommandPostprocessingContext<C>, Long>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<C, Pair<CommandPostprocessingContext<C>, Long>> eldest) {
                return this.size() > 100;
            }
        };
        this.timeoutMillis = timeoutTimeUnit.toMillis(timeout);
    }

    private void notifyConsumer(@NonNull CommandPostprocessingContext<C> context) {
        this.notifier.accept(context);
    }

    private void addPending(@NonNull CommandPostprocessingContext<C> context) {
        this.pendingCommands.put(context.getCommandContext().getSender(), Pair.of(context, System.currentTimeMillis()));
    }

    public @NonNull Optional<CommandPostprocessingContext<C>> getPending(@NonNull C sender) {
        Pair<CommandPostprocessingContext<C>, Long> pair = this.pendingCommands.remove(sender);
        if (pair != null && System.currentTimeMillis() < pair.getSecond() + this.timeoutMillis) {
            return Optional.of(pair.getFirst());
        }
        return Optional.empty();
    }

    public @NonNull SimpleCommandMeta.Builder decorate(@NonNull SimpleCommandMeta.Builder builder) {
        return builder.with(META_CONFIRMATION_REQUIRED, true);
    }

    public void registerConfirmationProcessor(@NonNull CommandManager<C> manager) {
        manager.registerCommandPostProcessor(new CommandConfirmationPostProcessor());
    }

    public @NonNull CommandExecutionHandler<C> createConfirmationExecutionHandler() {
        return context -> {
            Optional pending = this.getPending(context.getSender());
            if (pending.isPresent()) {
                CommandPostprocessingContext postprocessingContext = pending.get();
                postprocessingContext.getCommand().getCommandExecutionHandler().execute(postprocessingContext.getCommandContext());
            } else {
                this.errorNotifier.accept(context.getSender());
            }
        };
    }

    private final class CommandConfirmationPostProcessor
    implements CommandPostprocessor<C> {
        private CommandConfirmationPostProcessor() {
        }

        @Override
        public void accept(@NonNull CommandPostprocessingContext<C> context) {
            if (!context.getCommand().getCommandMeta().getOrDefault(META_CONFIRMATION_REQUIRED, false).booleanValue()) {
                return;
            }
            CommandConfirmationManager.this.addPending(context);
            CommandConfirmationManager.this.notifyConsumer(context);
            ConsumerService.interrupt();
        }
    }
}

