/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.meta;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.meta.SimpleCommandMeta;
import ca.stellardrift.permissionsex.ext.commandframework.meta.SimpleKey;
import ca.stellardrift.permissionsex.ext.geantyref.GenericTypeReflector;
import ca.stellardrift.permissionsex.ext.geantyref.TypeToken;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public abstract class CommandMeta {
    private static final Key<String> LEGACY_HIDDEN = Key.of(String.class, "hidden");
    public static final Key<String> DESCRIPTION = Key.of(String.class, "description");
    public static final Key<String> LONG_DESCRIPTION = Key.of(String.class, "long-description");
    public static final Key<Boolean> HIDDEN = Key.of(Boolean.class, "cloud:hidden", meta -> Boolean.valueOf(meta.getOrDefault(LEGACY_HIDDEN, "false")));

    public static @NonNull SimpleCommandMeta.Builder simple() {
        return SimpleCommandMeta.builder();
    }

    public final @NonNull String toString() {
        return "";
    }

    @Deprecated
    public abstract @NonNull Optional<String> getValue(@NonNull String var1);

    @Deprecated
    public abstract @NonNull String getOrDefault(@NonNull String var1, @NonNull String var2);

    public abstract <V> @NonNull Optional<V> get(@NonNull Key<V> var1);

    public abstract <V> @NonNull V getOrDefault(@NonNull Key<V> var1, @NonNull V var2);

    @Deprecated
    public abstract @NonNull Map<@NonNull String, @NonNull String> getAll();

    public abstract @NonNull Map<@NonNull String, @NonNull ?> getAllValues();

    public static interface Key<V> {
        public static <T> @NonNull Key<T> of(@NonNull Class<T> type, @NonNull String key) {
            if (GenericTypeReflector.isMissingTypeParameters(type)) {
                throw new IllegalArgumentException("Raw type " + type + " is prohibited");
            }
            return new SimpleKey<T>(TypeToken.get(Objects.requireNonNull(type, "type")), Objects.requireNonNull(key, "key"), null);
        }

        public static <T> @NonNull Key<T> of(@NonNull TypeToken<T> type, @NonNull String key) {
            return new SimpleKey<T>(Objects.requireNonNull(type, "type"), Objects.requireNonNull(key, "key"), null);
        }

        public static <T> @NonNull Key<T> of(@NonNull Class<T> type, @NonNull String key, @NonNull Function<@NonNull CommandMeta, @Nullable T> fallbackDerivation) {
            return new SimpleKey<T>(TypeToken.get(Objects.requireNonNull(type, "type")), Objects.requireNonNull(key, "key"), fallbackDerivation);
        }

        public static <T> @NonNull Key<T> of(@NonNull TypeToken<T> type, @NonNull String key, @NonNull Function<@NonNull CommandMeta, @Nullable T> fallbackDerivation) {
            return new SimpleKey<T>(Objects.requireNonNull(type, "type"), Objects.requireNonNull(key, "key"), fallbackDerivation);
        }

        public @NonNull TypeToken<V> getValueType();

        public @NonNull String getName();

        public @Nullable Function<@NonNull CommandMeta, @Nullable V> getFallbackDerivation();
    }
}

