/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.minecraft.extras;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.TextColor;
import java.util.regex.Pattern;

final class ComponentHelper {
    public static final Pattern SPECIAL_CHARACTERS_PATTERN = Pattern.compile("[^\\s\\w\\-]");

    private ComponentHelper() {
    }

    public static @NonNull Component highlight(@NonNull Component component, @NonNull TextColor highlightColor) {
        return component.replaceText(config -> {
            config.match(SPECIAL_CHARACTERS_PATTERN);
            config.replacement(match -> match.color(highlightColor));
        });
    }

    public static @NonNull Component repeat(@NonNull Component component, int repetitions) {
        TextComponent.Builder builder = Component.text();
        for (int i = 0; i < repetitions; ++i) {
            builder.append(component);
        }
        return builder.build();
    }

    public static int length(@NonNull Component component) {
        int length = 0;
        if (component instanceof TextComponent) {
            length += ((TextComponent)component).content().length();
        }
        for (Component child : component.children()) {
            length += ComponentHelper.length(child);
        }
        return length;
    }
}

