/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.minecraft.extras;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.commandframework.CommandManager;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.ArgumentParseException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.CommandExecutionException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.InvalidCommandSenderException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.InvalidSyntaxException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.NoPermissionException;
import ca.stellardrift.permissionsex.ext.commandframework.minecraft.extras.ComponentHelper;
import ca.stellardrift.permissionsex.ext.kyori.adventure.audience.Audience;
import ca.stellardrift.permissionsex.ext.kyori.adventure.identity.Identity;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.event.ClickEvent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.event.HoverEvent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.NamedTextColor;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.TextColor;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.TextDecoration;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class MinecraftExceptionHandler<C> {
    public static final Function<Exception, Component> DEFAULT_INVALID_SYNTAX_FUNCTION = e -> ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("Invalid command syntax. Correct command syntax is: ", (TextColor)NamedTextColor.RED))).append(ComponentHelper.highlight(Component.text(String.format("/%s", ((InvalidSyntaxException)e).getCorrectSyntax()), (TextColor)NamedTextColor.GRAY), NamedTextColor.WHITE))).build();
    public static final Function<Exception, Component> DEFAULT_INVALID_SENDER_FUNCTION = e -> ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("Invalid command sender. You must be of type ", (TextColor)NamedTextColor.RED))).append((Component)Component.text(((InvalidCommandSenderException)e).getRequiredSender().getSimpleName(), (TextColor)NamedTextColor.GRAY))).build();
    public static final Function<Exception, Component> DEFAULT_NO_PERMISSION_FUNCTION = e -> Component.text("I'm sorry, but you do not have permission to perform this command. \nPlease contact the server administrators if you believe that this is in error.", (TextColor)NamedTextColor.RED);
    public static final Function<Exception, Component> DEFAULT_ARGUMENT_PARSING_FUNCTION = e -> ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("Invalid command argument: ", (TextColor)NamedTextColor.RED))).append((Component)Component.text(e.getCause().getMessage(), (TextColor)NamedTextColor.GRAY))).build();
    public static final Function<Exception, Component> DEFAULT_COMMAND_EXECUTION_FUNCTION = e -> {
        Throwable cause = e.getCause();
        cause.printStackTrace();
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter(writer));
        String stackTrace = writer.toString().replaceAll("\t", "    ");
        HoverEvent<Component> hover = HoverEvent.showText(((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(stackTrace))).append((Component)Component.newline())).append((Component)Component.text("    Click to copy", (TextColor)NamedTextColor.GRAY, TextDecoration.ITALIC)));
        ClickEvent click = ClickEvent.copyToClipboard(stackTrace);
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("An internal error occurred while attempting to perform this command.", (TextColor)NamedTextColor.RED))).hoverEvent(hover)).clickEvent(click)).build();
    };
    private final Map<ExceptionType, BiFunction<C, Exception, Component>> componentBuilders = new HashMap<ExceptionType, BiFunction<C, Exception, Component>>();
    private Function<Component, Component> decorator = Function.identity();

    public @NonNull MinecraftExceptionHandler<C> withInvalidSyntaxHandler() {
        return this.withHandler(ExceptionType.INVALID_SYNTAX, DEFAULT_INVALID_SYNTAX_FUNCTION);
    }

    public @NonNull MinecraftExceptionHandler<C> withInvalidSenderHandler() {
        return this.withHandler(ExceptionType.INVALID_SENDER, DEFAULT_INVALID_SENDER_FUNCTION);
    }

    public @NonNull MinecraftExceptionHandler<C> withNoPermissionHandler() {
        return this.withHandler(ExceptionType.NO_PERMISSION, DEFAULT_NO_PERMISSION_FUNCTION);
    }

    public @NonNull MinecraftExceptionHandler<C> withArgumentParsingHandler() {
        return this.withHandler(ExceptionType.ARGUMENT_PARSING, DEFAULT_ARGUMENT_PARSING_FUNCTION);
    }

    public @NonNull MinecraftExceptionHandler<C> withCommandExecutionHandler() {
        return this.withHandler(ExceptionType.COMMAND_EXECUTION, DEFAULT_COMMAND_EXECUTION_FUNCTION);
    }

    public @NonNull MinecraftExceptionHandler<C> withDefaultHandlers() {
        return this.withArgumentParsingHandler().withInvalidSenderHandler().withInvalidSyntaxHandler().withNoPermissionHandler().withCommandExecutionHandler();
    }

    public @NonNull MinecraftExceptionHandler<C> withHandler(@NonNull ExceptionType type, @NonNull Function<@NonNull Exception, @NonNull Component> componentBuilder) {
        return this.withHandler(type, (C sender, Exception exception) -> (Component)componentBuilder.apply((Exception)exception));
    }

    public @NonNull MinecraftExceptionHandler<C> withHandler(@NonNull ExceptionType type, @NonNull BiFunction<@NonNull C, @NonNull Exception, @NonNull Component> componentBuilder) {
        this.componentBuilders.put(type, componentBuilder);
        return this;
    }

    public @NonNull MinecraftExceptionHandler<C> withDecorator(@NonNull Function<@NonNull Component, @NonNull Component> decorator) {
        this.decorator = decorator;
        return this;
    }

    public void apply(@NonNull CommandManager<C> manager, @NonNull Function<@NonNull C, @NonNull Audience> audienceMapper) {
        if (this.componentBuilders.containsKey((Object)ExceptionType.INVALID_SYNTAX)) {
            manager.registerExceptionHandler(InvalidSyntaxException.class, (c, e) -> ((Audience)audienceMapper.apply(c)).sendMessage(Identity.nil(), this.decorator.apply(this.componentBuilders.get((Object)ExceptionType.INVALID_SYNTAX).apply((C)c, (Exception)e))));
        }
        if (this.componentBuilders.containsKey((Object)ExceptionType.INVALID_SENDER)) {
            manager.registerExceptionHandler(InvalidCommandSenderException.class, (c, e) -> ((Audience)audienceMapper.apply(c)).sendMessage(Identity.nil(), this.decorator.apply(this.componentBuilders.get((Object)ExceptionType.INVALID_SENDER).apply((C)c, (Exception)e))));
        }
        if (this.componentBuilders.containsKey((Object)ExceptionType.NO_PERMISSION)) {
            manager.registerExceptionHandler(NoPermissionException.class, (c, e) -> ((Audience)audienceMapper.apply(c)).sendMessage(Identity.nil(), this.decorator.apply(this.componentBuilders.get((Object)ExceptionType.NO_PERMISSION).apply((C)c, (Exception)e))));
        }
        if (this.componentBuilders.containsKey((Object)ExceptionType.ARGUMENT_PARSING)) {
            manager.registerExceptionHandler(ArgumentParseException.class, (c, e) -> ((Audience)audienceMapper.apply(c)).sendMessage(Identity.nil(), this.decorator.apply(this.componentBuilders.get((Object)ExceptionType.ARGUMENT_PARSING).apply((C)c, (Exception)e))));
        }
        if (this.componentBuilders.containsKey((Object)ExceptionType.COMMAND_EXECUTION)) {
            manager.registerExceptionHandler(CommandExecutionException.class, (c, e) -> ((Audience)audienceMapper.apply(c)).sendMessage(Identity.nil(), this.decorator.apply(this.componentBuilders.get((Object)ExceptionType.COMMAND_EXECUTION).apply((C)c, (Exception)e))));
        }
    }

    public static enum ExceptionType {
        INVALID_SYNTAX,
        INVALID_SENDER,
        NO_PERMISSION,
        ARGUMENT_PARSING,
        COMMAND_EXECUTION;

    }
}

