/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.minecraft.extras;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.commandframework.CommandComponent;
import ca.stellardrift.permissionsex.ext.commandframework.CommandHelpHandler;
import ca.stellardrift.permissionsex.ext.commandframework.CommandManager;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.minecraft.extras.AudienceProvider;
import ca.stellardrift.permissionsex.ext.commandframework.minecraft.extras.ComponentHelper;
import ca.stellardrift.permissionsex.ext.commandframework.minecraft.extras.Pagination;
import ca.stellardrift.permissionsex.ext.kyori.adventure.audience.Audience;
import ca.stellardrift.permissionsex.ext.kyori.adventure.identity.Identity;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ComponentLike;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.event.ClickEvent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.NamedTextColor;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.TextColor;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.TextDecoration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;

public final class MinecraftHelp<C> {
    public static final int DEFAULT_HEADER_FOOTER_LENGTH = 46;
    public static final int DEFAULT_MAX_RESULTS_PER_PAGE = 6;
    public static final HelpColors DEFAULT_HELP_COLORS = HelpColors.of(NamedTextColor.GOLD, NamedTextColor.GREEN, NamedTextColor.YELLOW, NamedTextColor.GRAY, NamedTextColor.DARK_GRAY);
    public static final String MESSAGE_HELP_TITLE = "help";
    public static final String MESSAGE_COMMAND = "command";
    public static final String MESSAGE_DESCRIPTION = "description";
    public static final String MESSAGE_NO_DESCRIPTION = "no_description";
    public static final String MESSAGE_ARGUMENTS = "arguments";
    public static final String MESSAGE_OPTIONAL = "optional";
    public static final String MESSAGE_SHOWING_RESULTS_FOR_QUERY = "showing_results_for_query";
    public static final String MESSAGE_NO_RESULTS_FOR_QUERY = "no_results_for_query";
    public static final String MESSAGE_AVAILABLE_COMMANDS = "available_commands";
    public static final String MESSAGE_CLICK_TO_SHOW_HELP = "click_to_show_help";
    public static final String MESSAGE_PAGE_OUT_OF_RANGE = "page_out_of_range";
    public static final String MESSAGE_CLICK_FOR_NEXT_PAGE = "click_for_next_page";
    public static final String MESSAGE_CLICK_FOR_PREVIOUS_PAGE = "click_for_previous_page";
    private final AudienceProvider<C> audienceProvider;
    private final CommandManager<C> commandManager;
    private final String commandPrefix;
    private final Map<String, String> messageMap = new HashMap<String, String>();
    private BiFunction<C, String, String> messageProvider = (sender, key) -> this.messageMap.get(key);
    private HelpColors colors = DEFAULT_HELP_COLORS;
    private int headerFooterLength = 46;
    private int maxResultsPerPage = 6;

    public MinecraftHelp(@NonNull String commandPrefix, @NonNull AudienceProvider<C> audienceProvider, @NonNull CommandManager<C> commandManager) {
        this.commandPrefix = commandPrefix;
        this.audienceProvider = audienceProvider;
        this.commandManager = commandManager;
        this.messageMap.put(MESSAGE_HELP_TITLE, "Help");
        this.messageMap.put(MESSAGE_COMMAND, "Command");
        this.messageMap.put(MESSAGE_DESCRIPTION, "Description");
        this.messageMap.put(MESSAGE_NO_DESCRIPTION, "No description");
        this.messageMap.put(MESSAGE_ARGUMENTS, "Arguments");
        this.messageMap.put(MESSAGE_OPTIONAL, "Optional");
        this.messageMap.put(MESSAGE_SHOWING_RESULTS_FOR_QUERY, "Showing search results for query");
        this.messageMap.put(MESSAGE_NO_RESULTS_FOR_QUERY, "No results for query");
        this.messageMap.put(MESSAGE_AVAILABLE_COMMANDS, "Available Commands");
        this.messageMap.put(MESSAGE_CLICK_TO_SHOW_HELP, "Click to show help for this command");
        this.messageMap.put(MESSAGE_PAGE_OUT_OF_RANGE, "Error: Page <page> is not in range. Must be in range [1, <max_pages>]");
        this.messageMap.put(MESSAGE_CLICK_FOR_NEXT_PAGE, "Click for next page");
        this.messageMap.put(MESSAGE_CLICK_FOR_PREVIOUS_PAGE, "Click for previous page");
    }

    public @NonNull CommandManager<C> getCommandManager() {
        return this.commandManager;
    }

    public @NonNull AudienceProvider<C> getAudienceProvider() {
        return this.audienceProvider;
    }

    public @NonNull Audience getAudience(@NonNull C sender) {
        return this.audienceProvider.apply((Object)sender);
    }

    public void setMessage(@NonNull String key, @NonNull String value) {
        this.messageMap.put(key, value);
    }

    public void setMessageProvider(@NonNull BiFunction<C, String, String> messageProvider) {
        this.messageProvider = messageProvider;
    }

    public void setHelpColors(@NonNull HelpColors colors) {
        this.colors = colors;
    }

    public @NonNull HelpColors getHelpColors() {
        return this.colors;
    }

    public void setHeaderFooterLength(int headerFooterLength) {
        this.headerFooterLength = headerFooterLength;
    }

    public void setMaxResultsPerPage(int maxResultsPerPage) {
        this.maxResultsPerPage = maxResultsPerPage;
    }

    public void queryCommands(@NonNull String rawQuery, @NonNull C recipient) {
        String query;
        int page;
        String[] splitQuery = rawQuery.split(" ");
        try {
            String pageText = splitQuery[splitQuery.length - 1];
            page = Integer.parseInt(pageText);
            query = rawQuery.substring(0, Math.max(rawQuery.lastIndexOf(pageText) - 1, 0));
        }
        catch (NumberFormatException e) {
            page = 1;
            query = rawQuery;
        }
        Audience audience = this.getAudience(recipient);
        this.printTopic(recipient, query, page, this.commandManager.getCommandHelpHandler().queryHelp(recipient, query));
    }

    private void printTopic(@NonNull C sender, @NonNull String query, int page,  @NonNull CommandHelpHandler.HelpTopic<C> helpTopic) {
        if (helpTopic instanceof CommandHelpHandler.IndexHelpTopic) {
            this.printIndexHelpTopic(sender, query, page, (CommandHelpHandler.IndexHelpTopic)helpTopic);
        } else if (helpTopic instanceof CommandHelpHandler.MultiHelpTopic) {
            this.printMultiHelpTopic(sender, query, page, (CommandHelpHandler.MultiHelpTopic)helpTopic);
        } else if (helpTopic instanceof CommandHelpHandler.VerboseHelpTopic) {
            this.printVerboseHelpTopic(sender, query, (CommandHelpHandler.VerboseHelpTopic)helpTopic);
        } else {
            throw new IllegalArgumentException("Unknown help topic type");
        }
    }

    private void printIndexHelpTopic(@NonNull C sender, @NonNull String query, int page,  @NonNull CommandHelpHandler.IndexHelpTopic<C> helpTopic) {
        Audience audience = this.getAudience(sender);
        if (helpTopic.isEmpty()) {
            audience.sendMessage(Identity.nil(), this.basicHeader(sender));
            audience.sendMessage(Identity.nil(), ((TextComponent)Component.text(this.messageProvider.apply(sender, MESSAGE_NO_RESULTS_FOR_QUERY) + ": \"", this.colors.text).append(this.highlight(Component.text("/" + query, this.colors.highlight)))).append(Component.text("\"", this.colors.text)));
            audience.sendMessage(Identity.nil(), this.footer(sender));
            return;
        }
        new Pagination<CommandHelpHandler.VerboseHelpEntry>((currentPage, maxPages) -> {
            ArrayList<Component> header = new ArrayList<Component>();
            header.add(this.paginatedHeader(sender, (int)currentPage, (int)maxPages));
            header.add(this.showingResults(sender, query));
            header.add(this.lastBranch().append(Component.text(String.format(" %s:", this.messageProvider.apply(sender, MESSAGE_AVAILABLE_COMMANDS)), this.colors.text)));
            return header;
        }, (helpEntry, isLastOfPage) -> {
            String description = helpEntry.getDescription().isEmpty() ? this.messageProvider.apply(sender, MESSAGE_CLICK_TO_SHOW_HELP) : helpEntry.getDescription();
            boolean lastBranch = isLastOfPage != false || helpTopic.getEntries().indexOf(helpEntry) == helpTopic.getEntries().size() - 1;
            return ((TextComponent)Component.text("   ").append(lastBranch ? this.lastBranch() : this.branch())).append(this.highlight(Component.text(String.format(" /%s", helpEntry.getSyntaxString()), this.colors.highlight)).hoverEvent(Component.text(description, this.colors.text)).clickEvent(ClickEvent.runCommand(this.commandPrefix + " " + helpEntry.getSyntaxString())));
        }, (currentPage, maxPages) -> this.paginatedFooter(sender, (int)currentPage, (int)maxPages, query), (attemptedPage, maxPages) -> this.pageOutOfRange(sender, (int)attemptedPage, (int)maxPages)).render(helpTopic.getEntries(), page, this.maxResultsPerPage).forEach(line -> audience.sendMessage(Identity.nil(), (Component)line));
    }

    private void printMultiHelpTopic(@NonNull C sender, @NonNull String query, int page,  @NonNull CommandHelpHandler.MultiHelpTopic<C> helpTopic) {
        Audience audience = this.getAudience(sender);
        int headerIndentation = helpTopic.getLongestPath().length();
        new Pagination<String>((currentPage, maxPages) -> {
            ArrayList<Component> header = new ArrayList<Component>();
            header.add(this.paginatedHeader(sender, (int)currentPage, (int)maxPages));
            header.add(this.showingResults(sender, query));
            header.add(this.lastBranch().append(this.highlight(Component.text(" /" + helpTopic.getLongestPath(), this.colors.highlight))));
            return header;
        }, (suggestion, isLastOfPage) -> {
            boolean lastBranch = isLastOfPage != false || helpTopic.getChildSuggestions().indexOf(suggestion) == helpTopic.getChildSuggestions().size() - 1;
            return ComponentHelper.repeat(Component.space(), headerIndentation).append(lastBranch ? this.lastBranch() : this.branch()).append(this.highlight(Component.text(" /" + suggestion, this.colors.highlight)).hoverEvent(Component.text(this.messageProvider.apply(sender, MESSAGE_CLICK_TO_SHOW_HELP), this.colors.text)).clickEvent(ClickEvent.runCommand(this.commandPrefix + " " + suggestion)));
        }, (currentPage, maxPages) -> this.paginatedFooter(sender, (int)currentPage, (int)maxPages, query), (attemptedPage, maxPages) -> this.pageOutOfRange(sender, (int)attemptedPage, (int)maxPages)).render(helpTopic.getChildSuggestions(), page, this.maxResultsPerPage).forEach(line -> audience.sendMessage(Identity.nil(), (Component)line));
    }

    private void printVerboseHelpTopic(@NonNull C sender, @NonNull String query,  @NonNull CommandHelpHandler.VerboseHelpTopic<C> helpTopic) {
        Audience audience = this.getAudience(sender);
        audience.sendMessage(Identity.nil(), this.basicHeader(sender));
        audience.sendMessage(Identity.nil(), this.showingResults(sender, query));
        String command = this.commandManager.getCommandSyntaxFormatter().apply(helpTopic.getCommand().getArguments(), null);
        audience.sendMessage(Identity.nil(), this.lastBranch().append(Component.text(" " + this.messageProvider.apply(sender, MESSAGE_COMMAND) + ": ", this.colors.primary)).append(this.highlight(Component.text("/" + command, this.colors.highlight))));
        String topicDescription = helpTopic.getDescription().isEmpty() ? this.messageProvider.apply(sender, MESSAGE_NO_DESCRIPTION) : helpTopic.getDescription();
        boolean hasArguments = helpTopic.getCommand().getArguments().size() > 1;
        audience.sendMessage(Identity.nil(), ((TextComponent)((TextComponent)Component.text("   ").append(hasArguments ? this.branch() : this.lastBranch())).append(Component.text(" " + this.messageProvider.apply(sender, MESSAGE_DESCRIPTION) + ": ", this.colors.primary))).append(Component.text(topicDescription, this.colors.text)));
        if (hasArguments) {
            audience.sendMessage(Identity.nil(), ((TextComponent)Component.text("   ").append(this.lastBranch())).append(Component.text(" " + this.messageProvider.apply(sender, MESSAGE_ARGUMENTS) + ":", this.colors.primary)));
            Iterator<CommandComponent<C>> iterator = helpTopic.getCommand().getComponents().iterator();
            iterator.next();
            while (iterator.hasNext()) {
                String description;
                CommandComponent<C> component = iterator.next();
                CommandArgument<C, ?> argument = component.getArgument();
                String syntax = this.commandManager.getCommandSyntaxFormatter().apply(Collections.singletonList(argument), null);
                TextComponent.Builder textComponent = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("       "))).append(iterator.hasNext() ? this.branch() : this.lastBranch())).append(this.highlight(Component.text(" " + syntax, this.colors.highlight)));
                if (!argument.isRequired()) {
                    textComponent.append((Component)Component.text(" (" + this.messageProvider.apply(sender, MESSAGE_OPTIONAL) + ")", this.colors.alternateHighlight));
                }
                if (!(description = component.getDescription().getDescription()).isEmpty()) {
                    ((TextComponent.Builder)textComponent.append((Component)Component.text(" - ", this.colors.accent))).append((Component)Component.text(description, this.colors.text));
                }
                audience.sendMessage(Identity.nil(), (ComponentLike)textComponent);
            }
        }
        audience.sendMessage(Identity.nil(), this.footer(sender));
    }

    private @NonNull Component showingResults(@NonNull C sender, @NonNull String query) {
        return ((TextComponent)Component.text(this.messageProvider.apply(sender, MESSAGE_SHOWING_RESULTS_FOR_QUERY) + ": \"", this.colors.text).append(this.highlight(Component.text("/" + query, this.colors.highlight)))).append(Component.text("\"", this.colors.text));
    }

    private @NonNull Component button(char icon, @NonNull String command, @NonNull String hoverText) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.space())).append((Component)Component.text('[', this.colors.accent))).append((Component)Component.text(icon, this.colors.alternateHighlight))).append((Component)Component.text(']', this.colors.accent))).append((Component)Component.space())).clickEvent(ClickEvent.runCommand(command))).hoverEvent(Component.text(hoverText, this.colors.text))).build();
    }

    private @NonNull Component footer(@NonNull C sender) {
        return this.paginatedFooter(sender, 1, 1, "");
    }

    private @NonNull Component paginatedFooter(@NonNull C sender, int currentPage, int maxPages, @NonNull String query) {
        boolean lastPage;
        boolean firstPage = currentPage == 1;
        boolean bl = lastPage = currentPage == maxPages;
        if (firstPage && lastPage) {
            return this.line(this.headerFooterLength);
        }
        String nextPageCommand = String.format("%s %s %s", this.commandPrefix, query, currentPage + 1);
        Component nextPageButton = this.button('\u2192', nextPageCommand, this.messageProvider.apply(sender, MESSAGE_CLICK_FOR_NEXT_PAGE));
        if (firstPage) {
            return this.header(sender, nextPageButton);
        }
        String previousPageCommand = String.format("%s %s %s", this.commandPrefix, query, currentPage - 1);
        Component previousPageButton = this.button('\u2190', previousPageCommand, this.messageProvider.apply(sender, MESSAGE_CLICK_FOR_PREVIOUS_PAGE));
        if (lastPage) {
            return this.header(sender, previousPageButton);
        }
        Object buttons = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(previousPageButton)).append(this.line(3))).append(nextPageButton)).build();
        return this.header(sender, (Component)buttons);
    }

    private @NonNull Component header(@NonNull C sender, @NonNull Component title) {
        int sideLength = (this.headerFooterLength - ComponentHelper.length(title)) / 2;
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(this.line(sideLength))).append(title)).append(this.line(sideLength))).build();
    }

    private @NonNull Component basicHeader(@NonNull C sender) {
        return this.header(sender, Component.text(" " + this.messageProvider.apply(sender, MESSAGE_HELP_TITLE) + " ", this.colors.highlight));
    }

    private @NonNull Component paginatedHeader(@NonNull C sender, int currentPage, int pages) {
        return this.header(sender, (Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(" " + this.messageProvider.apply(sender, MESSAGE_HELP_TITLE) + " ", this.colors.highlight))).append((Component)Component.text("(", this.colors.alternateHighlight))).append((Component)Component.text(currentPage, this.colors.text))).append((Component)Component.text("/", this.colors.alternateHighlight))).append((Component)Component.text(pages, this.colors.text))).append((Component)Component.text(")", this.colors.alternateHighlight))).append((Component)Component.space())).build());
    }

    private @NonNull Component line(int length) {
        return ComponentHelper.repeat(Component.text("-", this.colors.primary, TextDecoration.STRIKETHROUGH), length);
    }

    private @NonNull Component branch() {
        return Component.text("\u251c\u2500", this.colors.accent);
    }

    private @NonNull Component lastBranch() {
        return Component.text("\u2514\u2500", this.colors.accent);
    }

    private @NonNull Component highlight(@NonNull Component component) {
        return ComponentHelper.highlight(component, this.colors.alternateHighlight);
    }

    private @NonNull Component pageOutOfRange(@NonNull C sender, int attemptedPage, int maxPages) {
        return this.highlight(Component.text(this.messageProvider.apply(sender, MESSAGE_PAGE_OUT_OF_RANGE).replace("<page>", String.valueOf(attemptedPage)).replace("<max_pages>", String.valueOf(maxPages)), this.colors.text));
    }

    public static final class HelpColors {
        private final TextColor primary;
        private final TextColor highlight;
        private final TextColor alternateHighlight;
        private final TextColor text;
        private final TextColor accent;

        private HelpColors(@NonNull TextColor primary, @NonNull TextColor highlight, @NonNull TextColor alternateHighlight, @NonNull TextColor text, @NonNull TextColor accent) {
            this.primary = primary;
            this.highlight = highlight;
            this.alternateHighlight = alternateHighlight;
            this.text = text;
            this.accent = accent;
        }

        public @NonNull TextColor primary() {
            return this.primary;
        }

        public @NonNull TextColor highlight() {
            return this.highlight;
        }

        public @NonNull TextColor alternateHighlight() {
            return this.alternateHighlight;
        }

        public @NonNull TextColor text() {
            return this.text;
        }

        public @NonNull TextColor accent() {
            return this.accent;
        }

        public static @NonNull HelpColors of(@NonNull TextColor primary, @NonNull TextColor highlight, @NonNull TextColor alternateHighlight, @NonNull TextColor text, @NonNull TextColor accent) {
            return new HelpColors(primary, highlight, alternateHighlight, text, accent);
        }
    }
}

