/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.paper;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.CommandManager;
import ca.stellardrift.permissionsex.ext.commandframework.CommandTree;
import ca.stellardrift.permissionsex.ext.commandframework.brigadier.CloudBrigadierManager;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.BukkitCommandManager;
import ca.stellardrift.permissionsex.ext.commandframework.bukkit.CloudBukkitCapabilities;
import ca.stellardrift.permissionsex.ext.commandframework.execution.CommandExecutionCoordinator;
import ca.stellardrift.permissionsex.ext.commandframework.paper.AsyncCommandSuggestionsListener;
import ca.stellardrift.permissionsex.ext.commandframework.paper.PaperBrigadierListener;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class PaperCommandManager<C>
extends BukkitCommandManager<C> {
    private PaperBrigadierListener<C> paperBrigadierListener = null;

    public PaperCommandManager(@NonNull Plugin owningPlugin, @NonNull Function<CommandTree<C>, CommandExecutionCoordinator<C>> commandExecutionCoordinator, @NonNull Function<CommandSender, C> commandSenderMapper, @NonNull Function<C, CommandSender> backwardsCommandSenderMapper) throws Exception {
        super(owningPlugin, commandExecutionCoordinator, commandSenderMapper, backwardsCommandSenderMapper);
    }

    @Override
    public void registerBrigadier() throws BukkitCommandManager.BrigadierFailureException {
        this.requireState(CommandManager.RegistrationState.BEFORE_REGISTRATION);
        this.checkBrigadierCompatibility();
        if (!this.queryCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            super.registerBrigadier();
        } else {
            try {
                this.paperBrigadierListener = new PaperBrigadierListener(this);
                Bukkit.getPluginManager().registerEvents(this.paperBrigadierListener, this.getOwningPlugin());
            }
            catch (Throwable e) {
                throw new BukkitCommandManager.BrigadierFailureException(BukkitCommandManager.BrigadierFailureReason.PAPER_BRIGADIER_INITIALIZATION_FAILURE, e);
            }
        }
    }

    @Override
    public @Nullable CloudBrigadierManager<C, ?> brigadierManager() {
        if (this.paperBrigadierListener != null) {
            return this.paperBrigadierListener.brigadierManager();
        }
        return super.brigadierManager();
    }

    public void registerAsynchronousCompletions() throws IllegalStateException {
        this.requireState(CommandManager.RegistrationState.BEFORE_REGISTRATION);
        if (!this.queryCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            throw new IllegalStateException("Failed to register asynchronous command completion listener.");
        }
        Bukkit.getServer().getPluginManager().registerEvents(new AsyncCommandSuggestionsListener(this), this.getOwningPlugin());
    }
}

