/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.permission;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.commandframework.permission.CommandPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;

public final class OrPermission
implements CommandPermission {
    private final Collection<CommandPermission> permissions;

    private OrPermission(@NonNull Collection<CommandPermission> permissions) {
        this.permissions = permissions;
    }

    public static @NonNull CommandPermission of(@NonNull Collection<CommandPermission> permissions) {
        HashSet<CommandPermission> permissionSet = new HashSet<CommandPermission>();
        for (CommandPermission permission : permissions) {
            permissionSet.addAll(permission.getPermissions());
        }
        return new OrPermission(permissionSet);
    }

    @Override
    public @NonNull Collection<@NonNull CommandPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<CommandPermission> iterator = this.permissions.iterator();
        while (iterator.hasNext()) {
            CommandPermission permission = iterator.next();
            stringBuilder.append('(').append(permission.toString()).append(')');
            if (!iterator.hasNext()) continue;
            stringBuilder.append('|');
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrPermission that = (OrPermission)o;
        ArrayList<CommandPermission> local = new ArrayList<CommandPermission>(this.getPermissions());
        ArrayList<CommandPermission> foreign = new ArrayList<CommandPermission>(that.getPermissions());
        return local.equals(foreign);
    }

    public int hashCode() {
        return Objects.hash(this.getPermissions());
    }
}

