/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.commandframework.services;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.commandframework.services.PipelineException;
import ca.stellardrift.permissionsex.ext.commandframework.services.types.Service;
import java.util.function.Predicate;

enum ServiceFilterHandler {
    INSTANCE;


    <Context> boolean passes( @NonNull ServiceRepository.ServiceWrapper<? extends Service<Context, ?>> service, @NonNull Context context) {
        if (!service.isDefaultImplementation()) {
            for (Predicate predicate : service.getFilters()) {
                try {
                    if (predicate.test(context)) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new PipelineException(String.format("Failed to evaluate filter '%s' for '%s'", predicate.getClass().getCanonicalName(), service.toString()), e);
                }
            }
        }
        return true;
    }
}

