/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.config.impl;

import ca.stellardrift.permissionsex.ext.config.ConfigException;
import ca.stellardrift.permissionsex.ext.config.impl.AbstractConfigNodeValue;
import ca.stellardrift.permissionsex.ext.config.impl.AbstractConfigValue;
import ca.stellardrift.permissionsex.ext.config.impl.ConfigReference;
import ca.stellardrift.permissionsex.ext.config.impl.ConfigString;
import ca.stellardrift.permissionsex.ext.config.impl.Path;
import ca.stellardrift.permissionsex.ext.config.impl.PathParser;
import ca.stellardrift.permissionsex.ext.config.impl.SubstitutionExpression;
import ca.stellardrift.permissionsex.ext.config.impl.Token;
import ca.stellardrift.permissionsex.ext.config.impl.Tokens;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class ConfigNodeSimpleValue
extends AbstractConfigNodeValue {
    final Token token;

    ConfigNodeSimpleValue(Token value) {
        this.token = value;
    }

    @Override
    protected Collection<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    protected Token token() {
        return this.token;
    }

    protected AbstractConfigValue value() {
        if (Tokens.isValue(this.token)) {
            return Tokens.getValue(this.token);
        }
        if (Tokens.isUnquotedText(this.token)) {
            return new ConfigString.Unquoted(this.token.origin(), Tokens.getUnquotedText(this.token));
        }
        if (Tokens.isSubstitution(this.token)) {
            List<Token> expression = Tokens.getSubstitutionPathExpression(this.token);
            Path path = PathParser.parsePathExpression(expression.iterator(), this.token.origin());
            boolean optional = Tokens.getSubstitutionOptional(this.token);
            return new ConfigReference(this.token.origin(), new SubstitutionExpression(path, optional));
        }
        throw new ConfigException.BugOrBroken("ConfigNodeSimpleValue did not contain a valid value token");
    }
}

