/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.configurate;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.configurate.AbstractConfigurationNode;
import ca.stellardrift.permissionsex.ext.configurate.CommentedConfigurationNodeIntermediary;
import ca.stellardrift.permissionsex.ext.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.configurate.ConfigurationOptions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

abstract class AbstractCommentedConfigurationNode<N extends CommentedConfigurationNodeIntermediary<N>, A extends AbstractCommentedConfigurationNode<N, A>>
extends AbstractConfigurationNode<N, A>
implements CommentedConfigurationNodeIntermediary<N> {
    protected final AtomicReference<String> comment = new AtomicReference();

    protected AbstractCommentedConfigurationNode(@Nullable A parent, A copyOf) {
        super(parent, copyOf);
    }

    protected AbstractCommentedConfigurationNode(@Nullable Object key, @Nullable A parent, @NonNull ConfigurationOptions options) {
        super(key, parent, options);
    }

    @Override
    public @Nullable String comment() {
        return this.comment.get();
    }

    @Override
    public N comment(@Nullable String comment) {
        if (!Objects.equals(this.comment.getAndSet(comment), comment)) {
            this.attachIfNecessary();
        }
        return (N)((CommentedConfigurationNodeIntermediary)this.self());
    }

    @Override
    public N commentIfAbsent(String comment) {
        if (this.comment.compareAndSet(null, comment)) {
            this.attachIfNecessary();
        }
        return (N)((CommentedConfigurationNodeIntermediary)this.self());
    }

    @Override
    public N from(ConfigurationNode that) {
        String otherComment;
        if (that instanceof CommentedConfigurationNodeIntermediary && (otherComment = ((CommentedConfigurationNodeIntermediary)that).comment()) != null) {
            this.comment(otherComment);
        }
        return (N)((CommentedConfigurationNodeIntermediary)super.from(that));
    }

    @Override
    public N mergeFrom(ConfigurationNode other) {
        String otherComment;
        if (other instanceof CommentedConfigurationNodeIntermediary && (otherComment = ((CommentedConfigurationNodeIntermediary)other).comment()) != null) {
            this.commentIfAbsent(otherComment);
        }
        return (N)((CommentedConfigurationNodeIntermediary)super.mergeFrom(other));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractCommentedConfigurationNode)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractCommentedConfigurationNode that = (AbstractCommentedConfigurationNode)o;
        return Objects.equals(this.comment.get(), that.comment.get());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.comment.get());
        return result;
    }
}

