/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.configurate.serialize;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.configurate.serialize.CoercionFailedException;
import ca.stellardrift.permissionsex.ext.configurate.serialize.ScalarSerializer;
import ca.stellardrift.permissionsex.ext.configurate.serialize.SerializationException;
import java.lang.reflect.Type;
import java.util.function.Predicate;

final class CharSerializer
extends ScalarSerializer<Character> {
    CharSerializer() {
        super(Character.class);
    }

    @Override
    public Character deserialize(Type type, Object val) throws SerializationException {
        if (val instanceof String) {
            String strVal = (String)val;
            if (strVal.length() == 1) {
                return Character.valueOf(strVal.charAt(0));
            }
            throw new SerializationException(type, "Only single character expected, but received " + strVal);
        }
        if (val instanceof Number) {
            return Character.valueOf((char)((Number)val).shortValue());
        }
        throw new CoercionFailedException(type, val, "char");
    }

    @Override
    public Object serialize(@NonNull Character item, Predicate<Class<?>> typeSupported) {
        if (typeSupported.test(Character.TYPE)) {
            return item;
        }
        return item.toString();
    }
}

