/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.configurate.serialize;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.configurate.serialize.AbstractListChildSerializer;
import ca.stellardrift.permissionsex.ext.configurate.serialize.SerializationException;
import ca.stellardrift.permissionsex.ext.configurate.util.CheckedConsumer;
import ca.stellardrift.permissionsex.ext.geantyref.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

final class ListSerializer
extends AbstractListChildSerializer<List<?>> {
    static final TypeToken<List<?>> TYPE = new TypeToken<List<?>>(){};

    ListSerializer() {
    }

    @Override
    Type elementType(Type containerType) throws SerializationException {
        if (!(containerType instanceof ParameterizedType)) {
            throw new SerializationException(containerType, "Raw types are not supported for collections");
        }
        return ((ParameterizedType)containerType).getActualTypeArguments()[0];
    }

    @Override
    List<?> createNew(int length, Type elementType) {
        return new ArrayList(length);
    }

    @Override
    void forEachElement(List<?> collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
        for (Object el : collection) {
            action.accept(el);
        }
    }

    @Override
    void deserializeSingle(int index, List<?> collection, @Nullable Object deserialized) {
        collection.add(deserialized);
    }
}

