/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Argument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.ArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.NullArgument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.internal.StatementBinder;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.internal.strategies.LoggableBinderArgument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.ConfigRegistry;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.generic.GenericTypes;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

abstract class DelegatingArgumentFactory
implements ArgumentFactory.Preparable {
    private final Map<Class<?>, Function<Object, Argument>> builders = new IdentityHashMap();

    DelegatingArgumentFactory() {
    }

    @Override
    public Optional<Function<Object, Argument>> prepare(Type type, ConfigRegistry config) {
        return Optional.ofNullable(this.builders.get(GenericTypes.getErasedType(type)));
    }

    @Override
    public Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
        Class<?> expectedClass = GenericTypes.getErasedType(expectedType);
        if (value != null && expectedClass == Object.class) {
            expectedClass = value.getClass();
        }
        return Optional.ofNullable(this.builders.get(expectedClass)).map(r -> (Argument)r.apply(value));
    }

    @Override
    public Collection<? extends Type> prePreparedTypes() {
        return this.builders.keySet();
    }

    <T> void register(Class<T> klass, int sqlType, StatementBinder<T> binder) {
        this.builders.put(klass, value -> value == null ? new NullArgument(sqlType) : new LoggableBinderArgument<Object>(value, binder));
    }
}

