/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Argument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.NullArgument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ObjectArgument
implements Argument {
    private final Object value;
    private final Integer sqlType;

    @Deprecated
    public ObjectArgument(Object value, Integer sqlType) {
        this.sqlType = sqlType;
        this.value = value;
        if (sqlType == null && value == null) {
            throw new IllegalArgumentException("Null value provided without a type");
        }
    }

    public static Argument of(Object value) {
        return ObjectArgument.of(value, null);
    }

    public static Argument of(Object value, Integer sqlType) {
        if (value == null) {
            return new NullArgument(sqlType);
        }
        return new ObjectArgument(value, sqlType);
    }

    @Override
    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.value == null) {
            statement.setNull(position, this.sqlType);
        } else if (this.sqlType == null) {
            statement.setObject(position, this.value);
        } else {
            statement.setObject(position, this.value, this.sqlType);
        }
    }

    public String toString() {
        return (this.value == null ? "NULL" : String.valueOf(this.value)) + (this.sqlType == null ? "" : " (type " + this.sqlType + ")");
    }
}

