/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.internal;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Argument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Arguments;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.NamedArgumentFinder;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.internal.TypedValue;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.UnableToCreateStatementException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ObjectPropertyNamedArgumentFinder
implements NamedArgumentFinder {
    private final String prefix;
    protected final Object obj;
    private final Map<String, Optional<NamedArgumentFinder>> childArgumentFinders = new ConcurrentHashMap<String, Optional<NamedArgumentFinder>>();

    protected ObjectPropertyNamedArgumentFinder(String prefix, Object obj) {
        this.prefix = prefix == null || prefix.isEmpty() ? "" : prefix + ".";
        this.obj = obj;
    }

    @Override
    public final Optional<Argument> find(String name, StatementContext ctx) {
        if (name.startsWith(this.prefix)) {
            String actualName = name.substring(this.prefix.length());
            int separator = actualName.indexOf(46);
            if (separator != -1) {
                String parentName = actualName.substring(0, separator);
                String childName = actualName.substring(separator + 1);
                return this.childArgumentFinders.computeIfAbsent(parentName.endsWith("?") ? parentName.substring(0, parentName.length() - 1) : parentName, pn -> this.getValue((String)pn, ctx).map(typedValue -> this.getValueNested((TypedValue)typedValue, parentName, childName))).flatMap(arg -> arg.find(childName, ctx));
            }
            return this.getValue(actualName, ctx).map(tv -> ctx.findArgumentFor(tv.type, tv.value).orElseThrow(() -> new UnableToCreateStatementException(String.format("No argument factory registered for type [%s] for element [%s] on [%s]", tv.type, name, this.obj), ctx)));
        }
        return Optional.empty();
    }

    private NamedArgumentFinder getValueNested(TypedValue typedValue, String parentName, String childName) {
        if (Objects.nonNull(typedValue.value)) {
            return this.getNestedArgumentFinder(typedValue);
        }
        if (parentName.endsWith("?")) {
            return (n, c) -> Optional.of(c.getConfig(Arguments.class).getUntypedNullArgument());
        }
        throw new IllegalArgumentException(String.format("Trying to bind nested argument [%s], but found nullpointer at [%s], may mark it as an optional with [%s]", childName, parentName, parentName + '?'));
    }

    protected abstract Optional<TypedValue> getValue(String var1, StatementContext var2);

    protected abstract NamedArgumentFinder getNestedArgumentFinder(TypedValue var1);
}

