/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.internal;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.NamedArgumentFinder;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.internal.ObjectPropertyNamedArgumentFinder;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.internal.TypedValue;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.ConfigRegistry;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.reflect.internal.PojoProperties;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.reflect.internal.PojoTypes;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.UnableToCreateStatementException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;

public class PojoPropertyArguments
extends ObjectPropertyNamedArgumentFinder {
    protected final PojoProperties<?> properties;
    protected final ConfigRegistry config;

    public PojoPropertyArguments(String prefix, Object obj, Type type, ConfigRegistry config) {
        this(prefix, obj, config.get(PojoTypes.class).findFor(type).orElseThrow(() -> new UnableToCreateStatementException("Couldn't find pojo type of " + obj.getClass())), config);
    }

    protected PojoPropertyArguments(String prefix, Object obj, PojoProperties<?> properties, ConfigRegistry config) {
        super(prefix, obj);
        this.properties = properties;
        this.config = config;
    }

    @Override
    protected Optional<TypedValue> getValue(String name, StatementContext ctx) {
        return Optional.ofNullable(this.properties.getProperties().get(name)).map(PojoProperties.PojoProperty.class::cast).map(p -> new TypedValue(p.getQualifiedType(), p.get(this.obj)));
    }

    @Override
    public Collection<String> getNames() {
        return this.properties.getProperties().keySet();
    }

    @Override
    protected NamedArgumentFinder getNestedArgumentFinder(TypedValue value) {
        return new PojoPropertyArguments(null, value.getValue(), value.getType().getType(), this.config);
    }

    public String toString() {
        return "{lazy bean property arguments \"" + this.obj + "\"}";
    }
}

