/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.internal.strategies;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Argument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.internal.StatementBinder;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;

public class LoggableBinderArgument<T>
implements Argument {
    private final T value;
    private final StatementBinder<T> binder;

    public static Argument bindAsString(Object obj) {
        return new LoggableBinderArgument<String>(Objects.toString(obj, null), PreparedStatement::setString);
    }

    public LoggableBinderArgument(T value, StatementBinder<T> binder) {
        this.value = value;
        this.binder = binder;
    }

    @Override
    public void apply(int pos, PreparedStatement stmt, StatementContext ctx) throws SQLException {
        this.binder.bind(stmt, pos, this.value);
    }

    public String toString() {
        return Objects.toString(this.value);
    }
}

