/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.array;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Argument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.array.SqlArrayArgumentStrategy;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.array.SqlArrayType;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.IterableLike;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.stream.Stream;

class SqlArrayArgument<T>
implements Argument {
    private final String typeName;
    private final Object[] array;

    SqlArrayArgument(SqlArrayType<T> arrayType, Object newArray) {
        this.typeName = arrayType.getTypeName();
        Stream<Object> stream = IterableLike.stream(newArray);
        this.array = stream.map(arrayType::convertArrayElement).toArray();
    }

    @Override
    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        SqlArrayArgumentStrategy argumentStyle = ctx.getSqlArrayArgumentStrategy();
        switch (argumentStyle) {
            case SQL_ARRAY: {
                Array sqlArray = statement.getConnection().createArrayOf(this.typeName, this.array);
                ctx.addCleanable(sqlArray::free);
                statement.setArray(position, sqlArray);
                break;
            }
            case OBJECT_ARRAY: {
                statement.setObject(position, this.array);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown array argument style " + (Object)((Object)argumentStyle));
            }
        }
    }

    public String toString() {
        return this.typeName + "[] - " + Arrays.toString(this.array);
    }
}

