/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector.ArrayBuilder;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector.CollectorFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.generic.GenericTypes;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.stream.Collector;

class ArrayCollectorFactory
implements CollectorFactory {
    ArrayCollectorFactory() {
    }

    @Override
    public boolean accepts(Type containerType) {
        return GenericTypes.getErasedType(containerType).isArray();
    }

    @Override
    public Optional<Type> elementType(Type containerType) {
        return Optional.ofNullable(GenericTypes.getErasedType(containerType).getComponentType());
    }

    @Override
    public Collector<?, ?, ?> build(Type containerType) {
        Class<?> componentType = GenericTypes.getErasedType(containerType).getComponentType();
        return Collector.of(() -> new ArrayBuilder(componentType), ArrayBuilder::add, (left, right) -> {
            left.list.addAll(right.list);
            return left;
        }, ArrayBuilder::build, new Collector.Characteristics[0]);
    }
}

