/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector.ArrayCollectorFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector.CollectorFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector.EnumSetCollectorFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector.ListCollectorFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector.MapCollectorFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector.OptionalCollectorFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector.OptionalPrimitiveCollectorFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector.SetCollectorFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.JdbiConfig;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collector;

public class JdbiCollectors
implements JdbiConfig<JdbiCollectors> {
    private final List<CollectorFactory> factories = new CopyOnWriteArrayList<CollectorFactory>();
    private ConcurrentMap<Type, Optional<CollectorFactory>> factoryCache;

    public JdbiCollectors() {
        this.factoryCache = new ConcurrentHashMap<Type, Optional<CollectorFactory>>();
        this.register(new MapCollectorFactory());
        this.register(new OptionalCollectorFactory());
        this.register(new ListCollectorFactory());
        this.register(new SetCollectorFactory());
        this.register(new OptionalPrimitiveCollectorFactory());
        this.register(new ArrayCollectorFactory());
        this.register(new EnumSetCollectorFactory());
    }

    private JdbiCollectors(JdbiCollectors that) {
        this.factoryCache = that.factoryCache;
        this.factories.addAll(that.factories);
    }

    public JdbiCollectors register(CollectorFactory factory) {
        this.factories.add(0, factory);
        this.factoryCache = new ConcurrentHashMap<Type, Optional<CollectorFactory>>();
        return this;
    }

    public Optional<Collector<?, ?, ?>> findFor(Type containerType) {
        return this.findFactoryFor(containerType).map(f -> f.build(containerType));
    }

    public Optional<Type> findElementTypeFor(Type containerType) {
        return this.findFactoryFor(containerType).flatMap(f -> f.elementType(containerType));
    }

    private Optional<CollectorFactory> findFactoryFor(Type containerType) {
        Optional<CollectorFactory> entry = (Optional<CollectorFactory>)this.factoryCache.get(containerType);
        if (entry != null) {
            return entry;
        }
        entry = this.factories.stream().filter(f -> f.accepts(containerType)).findFirst();
        this.factoryCache.putIfAbsent(containerType, entry);
        return entry;
    }

    @Override
    public JdbiCollectors createCopy() {
        return new JdbiCollectors(this);
    }
}

