/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.UtilityClassException;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class MapCollectors {
    private MapCollectors() {
        throw new UtilityClassException();
    }

    public static <K, V, M extends Map<K, V>> Collector<Map.Entry<K, V>, ?, M> toMap(Supplier<M> mapFactory) {
        return Collector.of(mapFactory, MapCollectors::putEntry, MapCollectors::combine, new Collector.Characteristics[0]);
    }

    private static <K, V, M extends Map<K, V>> void putEntry(M map, Map.Entry<K, V> entry) {
        MapCollectors.putEntry(map, entry.getKey(), entry.getValue());
    }

    private static <K, V, M extends Map<K, V>> void putEntry(M map, K key, V value) {
        V oldValue = map.put(key, value);
        if (oldValue != null) {
            throw new IllegalStateException(String.format("Multiple values for Map key '%s': ['%s','%s',...]", key, oldValue, value));
        }
    }

    private static <K, V, M extends Map<K, V>> M combine(M a, M b) {
        b.forEach((k, v) -> MapCollectors.putEntry(a, k, v));
        return a;
    }
}

