/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.config;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.ArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Arguments;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.QualifiedArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.array.SqlArrayArgumentStrategy;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.array.SqlArrayType;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.array.SqlArrayTypeFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.array.SqlArrayTypes;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector.CollectorFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.collector.JdbiCollectors;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.ConfigRegistry;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.JdbiConfig;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.extension.ExtensionFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.extension.Extensions;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.generic.GenericType;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.ColumnMapper;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.ColumnMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.ColumnMappers;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.MapEntryMappers;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.QualifiedColumnMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.RowMapper;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.RowMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.RowMappers;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.qualifier.QualifiedType;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.SqlLogger;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.SqlParser;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.SqlStatements;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementCustomizer;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.TemplateEngine;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.TimingCollector;
import ca.stellardrift.permissionsex.ext.jdbi.v3.meta.Beta;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Configurable<This> {
    public ConfigRegistry getConfig();

    default public <C extends JdbiConfig<C>> C getConfig(Class<C> configClass) {
        return this.getConfig().get(configClass);
    }

    default public <C extends JdbiConfig<C>> This configure(Class<C> configClass, Consumer<C> configurer) {
        configurer.accept(this.getConfig(configClass));
        return (This)this;
    }

    default public This setTemplateEngine(TemplateEngine templateEngine) {
        return this.configure(SqlStatements.class, c -> c.setTemplateEngine(templateEngine));
    }

    default public This setSqlParser(SqlParser parser) {
        return this.configure(SqlStatements.class, c -> c.setSqlParser(parser));
    }

    @Deprecated
    default public This setTimingCollector(TimingCollector collector) {
        return this.configure(SqlStatements.class, c -> c.setTimingCollector(collector));
    }

    default public This setSqlLogger(SqlLogger sqlLogger) {
        return this.configure(SqlStatements.class, c -> c.setSqlLogger(sqlLogger));
    }

    default public This addCustomizer(StatementCustomizer customizer) {
        return this.configure(SqlStatements.class, c -> c.addCustomizer(customizer));
    }

    default public This define(String key, Object value) {
        return this.configure(SqlStatements.class, c -> c.define(key, value));
    }

    default public This registerArgument(ArgumentFactory factory) {
        return this.configure(Arguments.class, c -> c.register(factory));
    }

    @Beta
    default public This registerArgument(QualifiedArgumentFactory factory) {
        return this.configure(Arguments.class, c -> c.register(factory));
    }

    default public This setSqlArrayArgumentStrategy(SqlArrayArgumentStrategy strategy) {
        return this.configure(SqlArrayTypes.class, c -> c.setArgumentStrategy(strategy));
    }

    default public This setMapKeyColumn(String keyColumn) {
        return this.configure(MapEntryMappers.class, c -> c.setKeyColumn(keyColumn));
    }

    default public This setMapValueColumn(String valueColumn) {
        return this.configure(MapEntryMappers.class, c -> c.setValueColumn(valueColumn));
    }

    default public This registerArrayType(Class<?> elementType, String sqlTypeName) {
        return this.configure(SqlArrayTypes.class, c -> c.register(elementType, sqlTypeName));
    }

    default public <T> This registerArrayType(Class<T> elementType, String sqlTypeName, Function<T, ?> conversion) {
        return this.registerArrayType(SqlArrayTypeFactory.of(elementType, sqlTypeName, conversion));
    }

    default public This registerArrayType(SqlArrayType<?> arrayType) {
        return this.configure(SqlArrayTypes.class, c -> c.register(arrayType));
    }

    default public This registerArrayType(SqlArrayTypeFactory factory) {
        return this.configure(SqlArrayTypes.class, c -> c.register(factory));
    }

    default public This registerCollector(CollectorFactory factory) {
        return this.configure(JdbiCollectors.class, c -> c.register(factory));
    }

    default public This registerColumnMapper(ColumnMapper<?> mapper) {
        return this.configure(ColumnMappers.class, c -> c.register(mapper));
    }

    default public <T> This registerColumnMapper(GenericType<T> type, ColumnMapper<T> mapper) {
        return this.configure(ColumnMappers.class, c -> c.register(type, mapper));
    }

    default public This registerColumnMapper(Type type, ColumnMapper<?> mapper) {
        return this.configure(ColumnMappers.class, c -> c.register(type, mapper));
    }

    @Beta
    default public <T> This registerColumnMapper(QualifiedType<T> type, ColumnMapper<T> mapper) {
        return this.configure(ColumnMappers.class, c -> c.register(type, mapper));
    }

    default public This registerColumnMapper(ColumnMapperFactory factory) {
        return this.configure(ColumnMappers.class, c -> c.register(factory));
    }

    @Beta
    default public This registerColumnMapper(QualifiedColumnMapperFactory factory) {
        return this.configure(ColumnMappers.class, c -> c.register(factory));
    }

    default public This registerExtension(ExtensionFactory factory) {
        return this.configure(Extensions.class, c -> c.register(factory));
    }

    default public This registerRowMapper(RowMapper<?> mapper) {
        return this.configure(RowMappers.class, c -> c.register(mapper));
    }

    default public <T> This registerRowMapper(GenericType<T> type, RowMapper<T> mapper) {
        return this.configure(RowMappers.class, c -> c.register(type, mapper));
    }

    default public This registerRowMapper(Type type, RowMapper<?> mapper) {
        return this.configure(RowMappers.class, c -> c.register(type, mapper));
    }

    default public This registerRowMapper(RowMapperFactory factory) {
        return this.configure(RowMappers.class, c -> c.register(factory));
    }
}

