/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.enums.internal;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.array.SqlArrayType;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.array.SqlArrayTypeFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.ConfigRegistry;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.enums.EnumStrategy;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.generic.GenericTypes;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.EnumStrategies;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.qualifier.QualifiedType;
import java.lang.reflect.Type;
import java.util.Optional;

public class EnumSqlArrayTypeFactory
implements SqlArrayTypeFactory {
    @Override
    public Optional<SqlArrayType<?>> build(Type elementType, ConfigRegistry config) {
        return Optional.of(elementType).map(GenericTypes::getErasedType).filter(c -> Enum.class.isAssignableFrom((Class<?>)c)).map(clazz -> this.makeSqlArrayType((Class)clazz, config));
    }

    private <E extends Enum<E>> SqlArrayType<E> makeSqlArrayType(Class<E> enumClass, ConfigRegistry config) {
        boolean byName = EnumStrategy.BY_NAME == config.get(EnumStrategies.class).findStrategy(QualifiedType.of(enumClass));
        return byName ? SqlArrayType.of("varchar", Enum::name) : SqlArrayType.of("integer", Enum::ordinal);
    }
}

