/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.exceptions.Unchecked;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class CollectionCollectors {
    private static final Supplier<Collector> SET_COLLECTOR = CollectionCollectors.setFactory();

    private CollectionCollectors() {
    }

    private static Supplier<Collector> setFactory() {
        try {
            MethodHandle mh = MethodHandles.publicLookup().findStatic(Collectors.class, "toUnmodifiableSet", MethodType.methodType(Collector.class));
            return Unchecked.supplier(() -> mh.invokeExact());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return () -> Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet);
        }
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiableSet() {
        return SET_COLLECTOR.get();
    }
}

