/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.array.SqlArrayMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.ConfigRegistry;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.JdbiConfig;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.enums.internal.EnumMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.generic.GenericType;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.JdbiOptionals;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.BoxedMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.ColumnMapper;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.ColumnMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.EssentialsMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.InferredColumnMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.InternetMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.JavaTimeMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.NVarcharMapper;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.OptionalMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.PrimitiveMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.QualifiedColumnMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.SqlTimeMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.qualifier.QualifiedType;
import ca.stellardrift.permissionsex.ext.jdbi.v3.meta.Beta;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ColumnMappers
implements JdbiConfig<ColumnMappers> {
    private final List<QualifiedColumnMapperFactory> factories = new CopyOnWriteArrayList<QualifiedColumnMapperFactory>();
    private final ConcurrentHashMap<QualifiedType<?>, Optional<? extends ColumnMapper<?>>> cache = new ConcurrentHashMap();
    private boolean coalesceNullPrimitivesToDefaults = true;
    private ConfigRegistry registry;

    public ColumnMappers() {
        this.register(new SqlArrayMapperFactory());
        this.register(new JavaTimeMapperFactory());
        this.register(new SqlTimeMapperFactory());
        this.register(new InternetMapperFactory());
        this.register(new EssentialsMapperFactory());
        this.register(new BoxedMapperFactory());
        this.register(new PrimitiveMapperFactory());
        this.register(new OptionalMapperFactory());
        this.register(new EnumMapperFactory());
        this.register(new NVarcharMapper());
    }

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    private ColumnMappers(ColumnMappers that) {
        this.factories.addAll(that.factories);
        this.cache.putAll(that.cache);
        this.coalesceNullPrimitivesToDefaults = that.coalesceNullPrimitivesToDefaults;
    }

    public ColumnMappers register(ColumnMapper<?> mapper) {
        return this.register(new InferredColumnMapperFactory(mapper));
    }

    public <T> ColumnMappers register(GenericType<T> type, ColumnMapper<T> mapper) {
        return this.register(ColumnMapperFactory.of(type.getType(), mapper));
    }

    public ColumnMappers register(Type type, ColumnMapper<?> mapper) {
        return this.register(ColumnMapperFactory.of(type, mapper));
    }

    @Beta
    public <T> ColumnMappers register(QualifiedType<T> type, ColumnMapper<T> mapper) {
        return this.register(QualifiedColumnMapperFactory.of(type, mapper));
    }

    public ColumnMappers register(ColumnMapperFactory factory) {
        return this.register(QualifiedColumnMapperFactory.adapt(factory));
    }

    @Beta
    public ColumnMappers register(QualifiedColumnMapperFactory factory) {
        this.factories.add(0, factory);
        this.cache.clear();
        return this;
    }

    public <T> Optional<ColumnMapper<T>> findFor(Class<T> type) {
        ColumnMapper mapper = this.findFor((Type)type).orElse(null);
        return Optional.ofNullable(mapper);
    }

    public <T> Optional<ColumnMapper<T>> findFor(GenericType<T> type) {
        ColumnMapper mapper = this.findFor(type.getType()).orElse(null);
        return Optional.ofNullable(mapper);
    }

    public Optional<ColumnMapper<?>> findFor(Type type) {
        return this.findFor(QualifiedType.of(type)).map(m -> m);
    }

    @Beta
    public <T> Optional<ColumnMapper<T>> findFor(QualifiedType<T> type) {
        Optional<ColumnMapper<T>> cached = this.cache.get(type);
        if (cached != null) {
            return cached;
        }
        Optional<ColumnMapper<T>> mapper = this.factories.stream().flatMap(factory -> JdbiOptionals.stream(factory.build(type, this.registry))).findFirst();
        this.cache.put(type, mapper);
        return mapper;
    }

    public boolean getCoalesceNullPrimitivesToDefaults() {
        return this.coalesceNullPrimitivesToDefaults;
    }

    public void setCoalesceNullPrimitivesToDefaults(boolean coalesceNullPrimitivesToDefaults) {
        this.coalesceNullPrimitivesToDefaults = coalesceNullPrimitivesToDefaults;
    }

    @Override
    public ColumnMappers createCopy() {
        return new ColumnMappers(this);
    }
}

