/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.ConfigRegistry;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.generic.GenericTypes;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.ColumnMapper;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.ColumnMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.GetterMapper;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.MappingException;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;

class InternetMapperFactory
implements ColumnMapperFactory {
    private final Map<Class<?>, ColumnMapper<?>> mappers = new IdentityHashMap();

    InternetMapperFactory() {
        this.mappers.put(InetAddress.class, InternetMapperFactory::getInetAddress);
        this.mappers.put(URL.class, new GetterMapper<URL>(ResultSet::getURL));
        this.mappers.put(URI.class, new GetterMapper<URI>(InternetMapperFactory::getURI));
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        Class<?> rawType = GenericTypes.getErasedType(type);
        return Optional.ofNullable(this.mappers.get(rawType));
    }

    private static URI getURI(ResultSet r, int i) throws SQLException {
        String s = r.getString(i);
        try {
            return s == null ? null : new URI(s);
        }
        catch (URISyntaxException e) {
            throw new SQLException("Failed to convert data to URI", e);
        }
    }

    private static InetAddress getInetAddress(ResultSet r, int i, StatementContext ctx) throws SQLException {
        String hostname = r.getString(i);
        try {
            return hostname == null ? null : InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            throw new MappingException("Could not map InetAddress", e);
        }
    }
}

