/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.CaseStrategy;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.MapMappers;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.RowMapper;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class MapMapper
implements RowMapper<Map<String, Object>> {
    @Deprecated
    private final Function<StatementContext, UnaryOperator<String>> caseStrategy;

    public MapMapper() {
        this.caseStrategy = ctx -> ctx.getConfig(MapMappers.class).getCaseChange();
    }

    public MapMapper(boolean toLowerCase) {
        this.caseStrategy = toLowerCase ? ctx -> CaseStrategy.LOCALE_LOWER : ctx -> CaseStrategy.NOP;
    }

    @Override
    public Map<String, Object> map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.specialize(rs, ctx).map(rs, ctx);
    }

    @Override
    public RowMapper<Map<String, Object>> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        List<String> columnNames = MapMapper.getColumnNames(rs, this.caseStrategy.apply(ctx));
        return (r, c) -> {
            LinkedHashMap row = new LinkedHashMap(columnNames.size());
            for (int i = 0; i < columnNames.size(); ++i) {
                row.put(columnNames.get(i), rs.getObject(i + 1));
            }
            return row;
        };
    }

    private static List<String> getColumnNames(ResultSet rs, UnaryOperator<String> caseChange) throws SQLException {
        LinkedHashSet<String> columnNames = new LinkedHashSet<String>();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String columnName = meta.getColumnName(i + 1);
            String alias = meta.getColumnLabel(i + 1);
            String name = (String)caseChange.apply(alias == null ? columnName : alias);
            boolean added = columnNames.add(name);
            if (added) continue;
            throw new RuntimeException("column " + name + " appeared twice in this resultset!");
        }
        return new ArrayList<String>(columnNames);
    }
}

