/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;

abstract class InstanceFactory<T> {
    private final Executable executable;

    protected InstanceFactory(Executable executable) {
        this.executable = Objects.requireNonNull(executable, "executable is null");
    }

    Class<?> getDeclaringClass() {
        return this.executable.getDeclaringClass();
    }

    int getParameterCount() {
        return this.executable.getParameterCount();
    }

    Parameter[] getParameters() {
        return this.executable.getParameters();
    }

    @Nullable
    <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.executable.getAnnotation(annotationClass);
    }

    @Nullable
    <A extends Annotation> A getAnnotationIncludingType(Class<A> annotationClass) {
        return (A)((Annotation)Stream.of(this.getAnnotation(annotationClass), this.executable.getDeclaringClass().getAnnotation(annotationClass)).filter(Objects::nonNull).findFirst().orElse(null));
    }

    abstract T newInstance(Object ... var1);

    public abstract String toString();
}

