/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.reflect;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.exceptions.Unchecked;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.reflect.InstanceFactory;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Function;

class StaticMethodInstanceFactory<T>
extends InstanceFactory<T> {
    private final Class<T> type;
    private final Function<Object[], Object> method;

    StaticMethodInstanceFactory(Class<T> type, Method method) {
        super(method);
        this.type = Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(method, "method is null");
        if (!StaticMethodInstanceFactory.isStaticFactoryMethodFor(method, type)) {
            throw new IllegalArgumentException(String.format("Given method \"%s\" is not a valid factory method for %s", method, type));
        }
        this.method = Unchecked.function(Unchecked.function(MethodHandles.lookup()::unreflect).apply(method)::invokeWithArguments);
    }

    private static boolean isStaticFactoryMethodFor(Method method, Class<?> type) {
        return Modifier.isStatic(method.getModifiers()) && type.isAssignableFrom(method.getReturnType());
    }

    @Override
    T newInstance(Object ... params) {
        return this.type.cast(this.method.apply(params));
    }

    @Override
    public String toString() {
        return this.method.toString();
    }
}

