/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Argument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Arguments;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.NamedArgumentFinder;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.internal.NamedArgumentFinderFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.internal.TypedValue;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.JdbiOptionals;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.exceptions.CheckedConsumer;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.exceptions.Sneaky;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.qualifier.QualifiedType;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.qualifier.Qualifiers;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.Binding;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.DescribedArgument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.ParsedParameters;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.PreparedBatch;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.SqlStatement;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.SqlStatements;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.UnableToCreateStatementException;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.internal.PreparedBinding;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

class ArgumentBinder<Stmt extends SqlStatement<?>> {
    final PreparedStatement stmt;
    final StatementContext ctx;
    final ParsedParameters params;
    final Map<QualifiedType<?>, Function<Object, Argument>> argumentFactoryByType = new HashMap();

    ArgumentBinder(PreparedStatement stmt, StatementContext ctx, ParsedParameters params) {
        this.stmt = stmt;
        this.ctx = ctx;
        this.params = params;
    }

    void bind(Binding binding) {
        if (this.params.isPositional()) {
            this.bindPositional(binding);
        } else {
            this.bindNamed(binding);
        }
    }

    void bindPositional(Binding binding) {
        boolean moreArgumentsProvidedThanDeclared;
        boolean bl = moreArgumentsProvidedThanDeclared = binding.positionals.size() != this.params.getParameterCount();
        if (moreArgumentsProvidedThanDeclared && !this.ctx.getConfig(SqlStatements.class).isUnusedBindingAllowed()) {
            throw new UnableToCreateStatementException("Superfluous positional param at (0 based) position " + this.params.getParameterCount(), this.ctx);
        }
        for (int index = 0; index < this.params.getParameterCount(); ++index) {
            QualifiedType<?> type = this.typeOf(binding.positionals.get(index));
            try {
                this.argumentFactoryForType(type).apply(ArgumentBinder.unwrap(binding.positionals.get(index))).apply(index + 1, this.stmt, this.ctx);
                continue;
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException("Exception while binding positional param at (0 based) position " + index, e, this.ctx);
            }
        }
    }

    void bindNamed(Binding binding) {
        List<String> paramNames = this.params.getParameterNames();
        this.bindNamedCheck(binding, paramNames);
        int i = 0;
        while (i < paramNames.size()) {
            int index = i++;
            this.wrapExceptions(() -> (String)paramNames.get(index), x -> {
                String name = (String)paramNames.get(index);
                Object value = binding.named.get(name);
                if (value == null && !binding.named.containsKey(name)) {
                    for (NamedArgumentFinder naf : binding.namedArgumentFinder) {
                        Optional<Argument> found = naf.find(name, this.ctx);
                        if (!found.isPresent()) continue;
                        found.get().apply(index + 1, this.stmt, this.ctx);
                        return;
                    }
                    throw this.missingNamedParameter(name, binding);
                }
                this.argumentFactoryForType(this.typeOf(value)).apply(ArgumentBinder.unwrap(value)).apply(index + 1, this.stmt, this.ctx);
            }).accept(null);
        }
    }

    void bindNamedCheck(Binding binding, List<String> paramNames) {
        boolean argumentsProvidedButNoneDeclared;
        boolean bl = argumentsProvidedButNoneDeclared = paramNames.isEmpty() && !binding.isEmpty();
        if (argumentsProvidedButNoneDeclared && !this.ctx.getConfig(SqlStatements.class).isUnusedBindingAllowed()) {
            throw new UnableToCreateStatementException(String.format("Superfluous named parameters provided while the query declares none: '%s'. This check may be disabled by calling getConfig(SqlStatements.class).setUnusedBindingAllowed(true) or using @AllowUnusedBindings in SQL object.", binding), this.ctx);
        }
    }

    QualifiedType<?> typeOf(Object value) {
        return value instanceof TypedValue ? ((TypedValue)value).getType() : this.ctx.getConfig(Qualifiers.class).qualifiedTypeOf((AnnotatedElement)((Object)Optional.ofNullable(value).map(Object::getClass).orElse(Object.class)));
    }

    @Deprecated
    Argument toArgument(Object found) {
        return this.argumentFactoryForType(this.typeOf(found)).apply(ArgumentBinder.unwrap(found));
    }

    Function<Object, Argument> argumentFactoryForType(QualifiedType<?> type) {
        return this.argumentFactoryByType.computeIfAbsent(type, qt -> {
            Arguments args = this.ctx.getConfig(Arguments.class);
            Function<Object, Argument> factory = args.prepareFor(type).orElse(v -> args.findFor(type, v).orElseThrow(() -> this.factoryNotFound(type, v)));
            return value -> DescribedArgument.wrap(this.ctx, (Argument)factory.apply(value), value);
        });
    }

    UnableToCreateStatementException missingNamedParameter(String name, Binding binding) {
        return new UnableToCreateStatementException(String.format("Missing named parameter '%s' in binding:%s", name, binding), this.ctx);
    }

    <T> Consumer<T> wrapExceptions(Supplier<String> paramName, CheckedConsumer<T> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException(String.format("Exception while binding named parameter '%s'", paramName.get()), e, this.ctx);
            }
            catch (Exception e) {
                throw Sneaky.throwAnyway(e);
            }
        };
    }

    private UnableToCreateStatementException factoryNotFound(QualifiedType<?> qualifiedType, Object value) {
        Object[] typeVars;
        Type type = qualifiedType.getType();
        if (type instanceof Class && (typeVars = ((Class)type).getTypeParameters()).length > 0) {
            return new UnableToCreateStatementException("No type parameters found for erased type '" + type + Arrays.toString(typeVars) + "' with qualifiers '" + qualifiedType.getQualifiers() + "'. To bind a generic type, prefer using bindByType.");
        }
        return new UnableToCreateStatementException("No argument factory registered for '" + value + "' of qualified type " + qualifiedType, this.ctx);
    }

    static Object unwrap(Object maybeTypedValue) {
        return maybeTypedValue instanceof TypedValue ? ((TypedValue)maybeTypedValue).getValue() : maybeTypedValue;
    }

    static class Prepared
    extends ArgumentBinder<PreparedBatch> {
        final PreparedBatch batch;
        final Consumer<PreparedBinding> preparedBinder;
        final List<String> paramNames;

        Prepared(PreparedBatch batch, ParsedParameters params, PreparedBinding example) {
            super(batch.stmt, batch.getContext(), params);
            this.batch = batch;
            this.paramNames = params.getParameterNames();
            this.preparedBinder = this.prepareBinder(example);
        }

        private Consumer<PreparedBinding> prepareBinder(PreparedBinding example) {
            ArrayList<Consumer<PreparedBinding>> innerBinders = new ArrayList<Consumer<PreparedBinding>>(this.paramNames.size());
            for (int i = 0; i < this.paramNames.size(); ++i) {
                int index = i;
                String name = this.paramNames.get(i);
                Object value = example.named.get(name);
                if (value == null && !example.named.containsKey(name)) {
                    Optional preparation = example.prepareKeys.keySet().stream().map(pk -> new AbstractMap.SimpleImmutableEntry<NamedArgumentFinderFactory.PrepareKey, Function<String, Optional<Function<Object, Argument>>>>((NamedArgumentFinderFactory.PrepareKey)pk, this.batch.preparedFinders.get(pk))).flatMap(e -> JdbiOptionals.stream(((Optional)((Function)e.getValue()).apply(name)).map(pf -> new AbstractMap.SimpleImmutableEntry(e.getKey(), (Function)pf)))).findFirst();
                    if (preparation.isPresent()) {
                        Map.Entry p = (Map.Entry)preparation.get();
                        innerBinders.add(this.wrapExceptions(() -> name, binding -> ((Argument)((Function)p.getValue()).apply(binding.prepareKeys.get(p.getKey()))).apply(index + 1, this.stmt, this.ctx)));
                        continue;
                    }
                    innerBinders.add(this.wrapExceptions(() -> name, binding -> binding.namedArgumentFinder.stream().flatMap(naf -> JdbiOptionals.stream(naf.find(name, this.ctx))).findFirst().orElseGet(() -> (Argument)binding.realizedBackupArgumentFinders.get().stream().flatMap(naf -> JdbiOptionals.stream(naf.find(name, this.ctx))).findFirst().orElseThrow(() -> this.missingNamedParameter(name, (Binding)binding))).apply(index + 1, this.stmt, this.ctx)));
                    continue;
                }
                Function<Object, Argument> binder = this.argumentFactoryForType(this.typeOf(value));
                innerBinders.add(this.wrapExceptions(() -> name, binding -> ((Argument)binder.apply(Prepared.unwrap(binding.named.get(name)))).apply(index + 1, this.stmt, this.ctx)));
            }
            return binding -> innerBinders.forEach(b -> b.accept(binding));
        }

        @Override
        void bindNamed(Binding binding) {
            this.bindNamedCheck(binding, this.paramNames);
            this.preparedBinder.accept((PreparedBinding)binding);
        }
    }
}

