/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Argument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.NamedArgumentFinder;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.internal.TypedValue;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.JdbiOptionals;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.qualifier.QualifiedType;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.ArgumentBinder;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.ParsedParameters;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Binding {
    protected final Map<Integer, Object> positionals = new HashMap<Integer, Object>();
    protected final Map<String, Object> named = new HashMap<String, Object>();
    protected final List<NamedArgumentFinder> namedArgumentFinder = new ArrayList<NamedArgumentFinder>();
    private final StatementContext ctx;

    protected Binding(StatementContext ctx) {
        this.ctx = ctx;
    }

    public void addPositional(int position, Argument argument) {
        this.addPositional(position, (Object)argument);
    }

    public void addNamed(String name, Argument argument) {
        this.addNamed(name, (Object)argument);
    }

    public void addPositional(int position, Object argument) {
        this.positionals.put(position, argument);
    }

    public void addNamed(String name, Object argument) {
        this.named.put(name, argument);
    }

    public void addPositional(int position, Object argument, QualifiedType<?> type) {
        this.positionals.put(position, new TypedValue(type, argument));
    }

    public void addNamed(String name, Object argument, QualifiedType<?> type) {
        this.named.put(name, new TypedValue(type, argument));
    }

    public void addNamedArgumentFinder(NamedArgumentFinder args) {
        this.namedArgumentFinder.add(args);
    }

    @Deprecated
    public Optional<Argument> findForName(String name, StatementContext ctx2) {
        Object found = this.named.get(name);
        if (found != null || this.named.containsKey(name)) {
            return Optional.of(new ArgumentBinder(null, ctx2, ParsedParameters.NONE).toArgument(found));
        }
        return this.namedArgumentFinder.stream().flatMap(arguments -> JdbiOptionals.stream(arguments.find(name, ctx2))).findFirst();
    }

    @Deprecated
    public Collection<String> getNames() {
        HashSet<String> names = new HashSet<String>(this.named.keySet());
        this.namedArgumentFinder.forEach(args -> names.addAll(args.getNames()));
        return Collections.unmodifiableSet(names);
    }

    @Deprecated
    public Optional<Argument> findForPosition(int position) {
        return Optional.ofNullable(new ArgumentBinder(null, this.ctx, ParsedParameters.NONE).toArgument(this.positionals.get(position)));
    }

    public String toString() {
        String positionalsDescription = this.positionals.entrySet().stream().map(x -> ((Integer)x.getKey()).toString() + ':' + ArgumentBinder.unwrap(x.getValue())).collect(Collectors.joining(","));
        String namedDescription = this.named.entrySet().stream().map(x -> (String)x.getKey() + ':' + ArgumentBinder.unwrap(x.getValue())).collect(Collectors.joining(","));
        String found = this.namedArgumentFinder.stream().map(Object::toString).collect(Collectors.joining(","));
        return "{positional:{" + positionalsDescription + "}, named:{" + namedDescription + "}, finder:[" + found + "]}";
    }

    public void clear() {
        this.positionals.clear();
        this.named.clear();
        this.namedArgumentFinder.clear();
    }

    public boolean isEmpty() {
        return this.positionals.isEmpty() && this.named.isEmpty() && this.namedArgumentFinder.isEmpty();
    }
}

