/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement;

import ca.stellardrift.permissionsex.ext.caffeine.cache.Caffeine;
import ca.stellardrift.permissionsex.ext.caffeine.cache.LoadingCache;
import ca.stellardrift.permissionsex.ext.caffeine.cache.stats.CacheStats;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.ParsedSql;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.SqlParser;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.UnableToCreateStatementException;
import ca.stellardrift.permissionsex.ext.jdbi.v3.meta.Beta;

abstract class CachingSqlParser
implements SqlParser {
    private final LoadingCache<String, ParsedSql> parsedSqlCache;

    CachingSqlParser() {
        this(Caffeine.newBuilder().maximumSize(1000L));
    }

    CachingSqlParser(Caffeine<Object, Object> cache) {
        this.parsedSqlCache = cache.build(this::internalParse);
    }

    @Override
    public ParsedSql parse(String sql, StatementContext ctx) {
        try {
            return this.parsedSqlCache.get(sql);
        }
        catch (IllegalArgumentException e) {
            throw new UnableToCreateStatementException("Exception parsing for named parameter replacement", e, ctx);
        }
    }

    @Beta
    public CacheStats cacheStats() {
        return this.parsedSqlCache.stats();
    }

    abstract ParsedSql internalParse(String var1);
}

