/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Argument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.JdbiCache;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.JdbiCaches;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.ArgumentBinder;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;

class DescribedArgument
implements Argument {
    private static final JdbiCache<Class<?>, Boolean> ARG_CLASS_HAS_TOSTRING = JdbiCaches.declare(type -> {
        try {
            return type.getMethod("toString", new Class[0]).getDeclaringClass() != Object.class;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return false;
        }
    });
    private final Argument arg;
    private final String description;

    DescribedArgument(Argument arg, Object value) {
        this.arg = arg;
        this.description = Objects.toString(ArgumentBinder.unwrap(value));
    }

    @Override
    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        this.arg.apply(position, statement, ctx);
    }

    public String toString() {
        return this.description;
    }

    public static Argument wrap(StatementContext ctx, Argument arg, Object value) {
        if (Boolean.TRUE.equals(ARG_CLASS_HAS_TOSTRING.get(arg.getClass(), ctx))) {
            return arg;
        }
        return new DescribedArgument(arg, value);
    }
}

