/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement;

import ca.stellardrift.permissionsex.ext.antlr.v4.runtime.CharStreams;
import ca.stellardrift.permissionsex.ext.antlr.v4.runtime.Token;
import ca.stellardrift.permissionsex.ext.caffeine.cache.Caffeine;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.lexer.HashStatementLexer;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.CachingSqlParser;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.ParsedSql;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.internal.ErrorListener;
import ca.stellardrift.permissionsex.ext.jdbi.v3.meta.Beta;

public class HashPrefixSqlParser
extends CachingSqlParser {
    public HashPrefixSqlParser() {
    }

    @Beta
    public HashPrefixSqlParser(Caffeine<Object, Object> cache) {
        super(cache);
    }

    @Override
    public String nameParameter(String rawName, StatementContext ctx) {
        return "#" + rawName;
    }

    @Override
    ParsedSql internalParse(String sql) {
        ParsedSql.Builder parsedSql = ParsedSql.builder();
        HashStatementLexer lexer = new HashStatementLexer(CharStreams.fromString(sql));
        lexer.addErrorListener(new ErrorListener());
        Token t = lexer.nextToken();
        while (t.getType() != -1) {
            switch (t.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    parsedSql.append(t.getText());
                    break;
                }
                case 5: {
                    parsedSql.appendNamedParameter(t.getText().substring(1));
                    break;
                }
                case 6: {
                    parsedSql.appendPositionalParameter();
                    break;
                }
                case 4: {
                    parsedSql.append(t.getText().substring(1));
                    break;
                }
            }
            t = lexer.nextToken();
        }
        return parsedSql.build();
    }
}

