/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement;

import ca.stellardrift.permissionsex.ext.antlr.v4.runtime.CharStreams;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.Handle;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.SqlScriptParser;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.Batch;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.SqlStatement;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.SqlStatements;
import java.util.ArrayList;
import java.util.List;

public class Script
extends SqlStatement<Script> {
    private final Handle handle;
    private final String sql;

    public Script(Handle h, String sql) {
        super(h, sql);
        this.handle = h;
        this.sql = sql;
    }

    public int[] execute() {
        List<String> statements = this.getStatements();
        Batch b = this.handle.createBatch();
        statements.forEach(b::add);
        return b.execute();
    }

    public void executeAsSeparateStatements() {
        for (String s : this.getStatements()) {
            this.handle.execute(s, new Object[0]);
        }
    }

    public List<String> getStatements() {
        return this.splitToStatements(this.getConfig(SqlStatements.class).getTemplateEngine().render(this.sql, this.getContext()));
    }

    private List<String> splitToStatements(String script) {
        ArrayList<String> statements = new ArrayList<String>();
        String lastStatement = new SqlScriptParser((t, sb) -> {
            this.addStatement(sb.toString(), statements);
            sb.setLength(0);
        }).parse(CharStreams.fromString(script));
        this.addStatement(lastStatement, statements);
        return statements;
    }

    private void addStatement(String statement, List<String> statements) {
        String trimmedStatement = statement.trim();
        if (trimmedStatement.isEmpty()) {
            return;
        }
        statements.add(trimmedStatement);
    }
}

