/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.core.transaction;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.Handle;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.HandleCallback;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.JdbiConfig;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.transaction.DelegatingTransactionHandler;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.transaction.LocalTransactionHandler;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.transaction.TransactionHandler;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.transaction.TransactionIsolationLevel;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class SerializableTransactionRunner
extends DelegatingTransactionHandler
implements TransactionHandler {
    private static final String SQLSTATE_TXN_SERIALIZATION_FAILED = "40001";

    public SerializableTransactionRunner() {
        this(LocalTransactionHandler.binding());
    }

    public SerializableTransactionRunner(TransactionHandler delegate) {
        super(delegate);
    }

    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, HandleCallback<R, X> callback) throws X {
        Configuration config = handle.getConfig(Configuration.class);
        int attempts = 1 + config.maxRetries;
        ArrayDeque<Exception> failures = new ArrayDeque<Exception>();
        while (true) {
            try {
                R result = this.getDelegate().inTransaction(handle, callback);
                config.onSuccess.accept(new ArrayList(failures));
                return result;
            }
            catch (Exception last) {
                Exception x = last;
                if (!this.isSqlState(config.serializationFailureSqlState, x)) {
                    throw last;
                }
                failures.addLast(x);
                config.onFailure.accept(new ArrayList(failures));
                if (--attempts > 0) continue;
                Exception toThrow = (Exception)failures.removeLast();
                while (!failures.isEmpty()) {
                    toThrow.addSuppressed((Throwable)failures.removeLast());
                }
                throw toThrow;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, TransactionIsolationLevel level, HandleCallback<R, X> callback) throws X {
        TransactionIsolationLevel initial = handle.getTransactionIsolationLevel();
        try {
            handle.setTransactionIsolation(level);
            R r = this.inTransaction(handle, callback);
            return r;
        }
        finally {
            handle.setTransactionIsolation(initial);
        }
    }

    @Override
    public TransactionHandler specialize(Handle handle) throws SQLException {
        return new SerializableTransactionRunner(this.getDelegate().specialize(handle));
    }

    protected boolean isSqlState(String expectedSqlState, Throwable throwable) {
        Throwable t = throwable;
        do {
            String sqlState;
            if (!(t instanceof SQLException) || (sqlState = ((SQLException)t).getSQLState()) == null || !sqlState.startsWith(expectedSqlState)) continue;
            return true;
        } while ((t = t.getCause()) != null);
        return false;
    }

    public static class Configuration
    implements JdbiConfig<Configuration> {
        private static final int DEFAULT_MAX_RETRIES = 5;
        private static final Consumer<List<Exception>> NOP = list -> {};
        private int maxRetries = 5;
        private String serializationFailureSqlState = "40001";
        private Consumer<List<Exception>> onFailure = NOP;
        private Consumer<List<Exception>> onSuccess = NOP;

        public Configuration() {
        }

        private Configuration(Configuration that) {
            this.maxRetries = that.maxRetries;
            this.serializationFailureSqlState = that.serializationFailureSqlState;
            this.onFailure = that.onFailure;
            this.onSuccess = that.onSuccess;
        }

        public Configuration setMaxRetries(int maxRetries) {
            if (maxRetries < 0) {
                throw new IllegalArgumentException("\"" + maxRetries + " retries\" makes no sense. Set a number >= 0 (default " + 5 + ").");
            }
            this.maxRetries = maxRetries;
            return this;
        }

        public Configuration setSerializationFailureSqlState(String serializationFailureSqlState) {
            this.serializationFailureSqlState = serializationFailureSqlState;
            return this;
        }

        public Configuration setOnFailure(Consumer<List<Exception>> onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        public Configuration setOnSuccess(Consumer<List<Exception>> onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        @Override
        public Configuration createCopy() {
            return new Configuration(this);
        }
    }
}

