/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.postgres;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.AbstractArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Argument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.ConfigRegistry;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.PgLobApi;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.PostgresTypes;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class BlobInputStreamArgumentFactory
extends AbstractArgumentFactory<InputStream> {
    BlobInputStreamArgumentFactory() {
        super(2004);
    }

    @Override
    protected Argument build(InputStream value, ConfigRegistry config) {
        return new LobInputStreamArgument(value);
    }

    static class LobInputStreamArgument
    implements Argument {
        private final InputStream value;

        LobInputStreamArgument(InputStream value) {
            this.value = value;
        }

        @Override
        public void apply(int pos, PreparedStatement stmt, StatementContext ctx) throws SQLException {
            PgLobApi lob = ctx.getConfig(PostgresTypes.class).getLobApi();
            long oid = lob.createLob();
            lob.writeLob(oid, this.value);
            stmt.setLong(pos, oid);
        }
    }
}

