/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.postgres;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.ConfigRegistry;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.ColumnMapper;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.ColumnMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.PostgresTypes;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;

class BlobInputStreamColumnMapperFactory
implements ColumnMapperFactory {
    BlobInputStreamColumnMapperFactory() {
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        if (InputStream.class != type) {
            return Optional.empty();
        }
        return Optional.of(new LobColumnMapper());
    }

    static class LobColumnMapper
    implements ColumnMapper<InputStream> {
        LobColumnMapper() {
        }

        @Override
        public InputStream map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
            return ctx.getConfig(PostgresTypes.class).getLobApi().readLob(r.getLong(columnNumber));
        }
    }
}

