/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.postgres;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.ConfigRegistry;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.ColumnMapper;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.mapper.ColumnMapperFactory;
import java.lang.reflect.Type;
import java.time.Period;
import java.util.Optional;
import org.postgresql.util.PGInterval;

public class PeriodColumnMapperFactory
implements ColumnMapperFactory {
    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        if (type != Period.class) {
            return Optional.empty();
        }
        return Optional.of((r, i, c) -> {
            Object obj = r.getObject(i);
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof PGInterval)) {
                throw new IllegalArgumentException(String.format("got non-pginterval %s", obj));
            }
            PGInterval interval = (PGInterval)obj;
            if (interval.getHours() != 0 || interval.getMinutes() != 0 || interval.getSeconds() != 0.0) {
                throw new IllegalArgumentException(String.format("pginterval \"%s\" is too granular to be represented as period", interval.getValue()));
            }
            return Period.of(interval.getYears(), interval.getMonths(), interval.getDays());
        });
    }
}

