/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.postgres;

import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.LargeObjectException;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.PgLobApi;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

class PgLobApiImpl
implements PgLobApi {
    private static final int BUF_SIZE = 4096;
    private final LargeObjectManager mgr;

    PgLobApiImpl(Connection conn) {
        try {
            this.mgr = conn.unwrap(PGConnection.class).getLargeObjectAPI();
        }
        catch (SQLException e) {
            throw new LargeObjectException(e);
        }
    }

    @Override
    public long createLob() {
        try {
            return this.mgr.createLO();
        }
        catch (SQLException e) {
            throw new LargeObjectException(e);
        }
    }

    @Override
    public void writeLob(long oid, InputStream data) {
        try (LargeObject lob = this.mgr.open(oid);){
            int read;
            byte[] buf = new byte[4096];
            while ((read = data.read(buf, 0, buf.length)) > -1) {
                if (read <= 0) continue;
                lob.write(buf, 0, read);
            }
        }
        catch (IOException | SQLException e) {
            throw new LargeObjectException(e);
        }
    }

    @Override
    public InputStream readLob(long oid) {
        try {
            return this.mgr.open(oid, 262144).getInputStream();
        }
        catch (SQLException e) {
            throw new LargeObjectException(e);
        }
    }

    @Override
    public void deleteLob(long oid) {
        try {
            this.mgr.delete(oid);
        }
        catch (SQLException e) {
            throw new LargeObjectException(e);
        }
    }
}

