/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.postgres;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.Handle;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.Jdbi;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.generic.GenericType;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.JdbiClassUtils;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.internal.exceptions.Unchecked;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.spi.JdbiPlugin;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.BlobInputStreamArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.BlobInputStreamColumnMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.ClobReaderArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.ClobReaderColumnMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.DurationArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.DurationColumnMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.HStoreArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.HStoreColumnMapper;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.InetArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.JavaTimeArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.JavaTimeMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.JsonArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.MacAddrArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.MacAddrColumnMapper;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.PGobjectArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.PGobjectColumnMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.PeriodArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.PeriodColumnMapperFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.PgLobApiImpl;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.PostgresTypes;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.TypedEnumArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.UUIDArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.internal.BitStringEnumSetArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.internal.BitStringEnumSetMapperFactory;
import java.sql.Connection;
import java.util.Map;
import java.util.UUID;
import org.postgresql.PGConnection;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGmoney;

public class PostgresPlugin
extends JdbiPlugin.Singleton {
    @Override
    public void customizeJdbi(Jdbi jdbi) {
        jdbi.registerArgument(new TypedEnumArgumentFactory());
        jdbi.registerArgument(new JavaTimeArgumentFactory());
        jdbi.registerArgument(new DurationArgumentFactory());
        jdbi.registerArgument(new PeriodArgumentFactory());
        jdbi.registerArgument(new InetArgumentFactory());
        jdbi.registerArgument(new HStoreArgumentFactory());
        jdbi.registerArgument(new MacAddrArgumentFactory());
        jdbi.registerArgument(new UUIDArgumentFactory());
        jdbi.registerArgument(new PGobjectArgumentFactory());
        jdbi.registerArgument(new BitStringEnumSetArgumentFactory());
        jdbi.registerArgument(new BlobInputStreamArgumentFactory());
        jdbi.registerArgument(new ClobReaderArgumentFactory());
        jdbi.registerArrayType(Short.TYPE, "smallint");
        jdbi.registerArrayType(Short.class, "smallint");
        jdbi.registerArrayType(Integer.TYPE, "integer");
        jdbi.registerArrayType(Integer.class, "integer");
        jdbi.registerArrayType(Long.TYPE, "bigint");
        jdbi.registerArrayType(Long.class, "bigint");
        jdbi.registerArrayType(String.class, "varchar");
        jdbi.registerArrayType(UUID.class, "uuid");
        jdbi.registerArrayType(Float.TYPE, "float4");
        jdbi.registerArrayType(Float.class, "float4");
        jdbi.registerArrayType(Double.TYPE, "float8");
        jdbi.registerArrayType(Double.class, "float8");
        jdbi.registerArrayType(PGbox.class, "box");
        jdbi.registerArrayType(PGcircle.class, "circle");
        jdbi.registerArrayType(PGInterval.class, "interval");
        jdbi.registerArrayType(PGline.class, "line");
        jdbi.registerArrayType(PGlseg.class, "lseg");
        jdbi.registerArrayType(PGmoney.class, "money");
        jdbi.registerArrayType(PGpath.class, "path");
        jdbi.registerArrayType(PGpoint.class, "point");
        jdbi.registerArrayType(PGpolygon.class, "polygon");
        jdbi.registerColumnMapper(new JavaTimeMapperFactory());
        jdbi.registerColumnMapper(new HStoreColumnMapper());
        jdbi.registerColumnMapper(new MacAddrColumnMapper());
        jdbi.registerColumnMapper(new DurationColumnMapperFactory());
        jdbi.registerColumnMapper(new PeriodColumnMapperFactory());
        jdbi.registerColumnMapper(new PGobjectColumnMapperFactory());
        jdbi.registerColumnMapper(new BitStringEnumSetMapperFactory());
        jdbi.registerColumnMapper(new BlobInputStreamColumnMapperFactory());
        jdbi.registerColumnMapper(new ClobReaderColumnMapperFactory());
        jdbi.registerArgument(new HStoreArgumentFactory()::build);
        jdbi.registerColumnMapper(new GenericType<Map<String, String>>(){}, new HStoreColumnMapper());
        if (JdbiClassUtils.isPresent("ca.stellardrift.permissionsex.ext.jdbi.v3.json.JsonConfig")) {
            jdbi.registerArgument(new JsonArgumentFactory());
        }
    }

    @Override
    public Handle customizeHandle(Handle handle) {
        Connection conn = handle.getConnection();
        PGConnection pgConnection = Unchecked.supplier(() -> conn.unwrap(PGConnection.class)).get();
        return (Handle)handle.configure(PostgresTypes.class, pt -> {
            pt.addTypesToConnection(pgConnection);
            pt.setLobApi(new PgLobApiImpl(conn));
        });
    }
}

