/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.internal;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Argument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.statement.StatementContext;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Collectors;

public class BitStringEnumSetArgument<E extends Enum<E>>
implements Argument {
    private final E[] enumConstants;
    private final EnumSet<E> elements;

    BitStringEnumSetArgument(Class<E> enumType, EnumSet<E> elements) {
        this.enumConstants = (Enum[])enumType.getEnumConstants();
        this.elements = elements;
    }

    @Override
    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        String bits = this.elements == null ? null : Arrays.stream(this.enumConstants).map(value -> this.elements.contains(value) ? "1" : "0").collect(Collectors.joining());
        statement.setString(position, bits);
    }
}

