/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.internal;

import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.Argument;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.argument.ArgumentFactory;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.config.ConfigRegistry;
import ca.stellardrift.permissionsex.ext.jdbi.v3.core.generic.GenericTypes;
import ca.stellardrift.permissionsex.ext.jdbi.v3.postgres.internal.BitStringEnumSetArgument;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Function;

public class BitStringEnumSetArgumentFactory
implements ArgumentFactory.Preparable {
    @Override
    public Optional<Function<Object, Argument>> prepare(Type type, ConfigRegistry config) {
        if (!EnumSet.class.isAssignableFrom(GenericTypes.getErasedType(type))) {
            return Optional.empty();
        }
        return Optional.of(BitStringEnumSetArgumentFactory.buildGeneric(type));
    }

    private static <E extends Enum<E>> Function<Object, Argument> buildGeneric(Type type) {
        Class enumType = GenericTypes.findGenericParameter(type, EnumSet.class).map(t -> (Class)t).orElseThrow(() -> new IllegalArgumentException("No generic type information for " + type));
        return value -> new BitStringEnumSetArgument(enumType, (EnumSet)value);
    }
}

