/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.kyori.adventure.audience;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.kyori.adventure.audience.Audiences;
import ca.stellardrift.permissionsex.ext.kyori.adventure.audience.EmptyAudience;
import ca.stellardrift.permissionsex.ext.kyori.adventure.audience.ForwardingAudience;
import ca.stellardrift.permissionsex.ext.kyori.adventure.audience.MessageType;
import ca.stellardrift.permissionsex.ext.kyori.adventure.bossbar.BossBar;
import ca.stellardrift.permissionsex.ext.kyori.adventure.identity.Identified;
import ca.stellardrift.permissionsex.ext.kyori.adventure.identity.Identity;
import ca.stellardrift.permissionsex.ext.kyori.adventure.inventory.Book;
import ca.stellardrift.permissionsex.ext.kyori.adventure.sound.Sound;
import ca.stellardrift.permissionsex.ext.kyori.adventure.sound.SoundStop;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ComponentLike;
import ca.stellardrift.permissionsex.ext.kyori.adventure.title.Title;
import java.util.Arrays;
import java.util.stream.Collector;

public interface Audience {
    public static @NonNull Audience empty() {
        return EmptyAudience.INSTANCE;
    }

    public static @NonNull Audience audience(Audience ... audiences) {
        int length = audiences.length;
        if (length == 0) {
            return Audience.empty();
        }
        if (length == 1) {
            return audiences[0];
        }
        return Audience.audience(Arrays.asList(audiences));
    }

    public static @NonNull ForwardingAudience audience(@NonNull Iterable<? extends Audience> audiences) {
        return () -> audiences;
    }

    public static @NonNull Collector<? super Audience, ?, ForwardingAudience> toAudience() {
        return Audiences.COLLECTOR;
    }

    default public void sendMessage(@NonNull ComponentLike message) {
        this.sendMessage(Identity.nil(), message);
    }

    default public void sendMessage(@NonNull Identified source, @NonNull ComponentLike message) {
        this.sendMessage(source, message.asComponent());
    }

    default public void sendMessage(@NonNull Identity source, @NonNull ComponentLike message) {
        this.sendMessage(source, message.asComponent());
    }

    default public void sendMessage(@NonNull Component message) {
        this.sendMessage(Identity.nil(), message);
    }

    default public void sendMessage(@NonNull Identified source, @NonNull Component message) {
        this.sendMessage(source, message, MessageType.SYSTEM);
    }

    default public void sendMessage(@NonNull Identity source, @NonNull Component message) {
        this.sendMessage(source, message, MessageType.SYSTEM);
    }

    default public void sendMessage(@NonNull ComponentLike message, @NonNull MessageType type) {
        this.sendMessage(Identity.nil(), message, type);
    }

    default public void sendMessage(@NonNull Identified source, @NonNull ComponentLike message, @NonNull MessageType type) {
        this.sendMessage(source, message.asComponent(), type);
    }

    default public void sendMessage(@NonNull Identity source, @NonNull ComponentLike message, @NonNull MessageType type) {
        this.sendMessage(source, message.asComponent(), type);
    }

    default public void sendMessage(@NonNull Component message, @NonNull MessageType type) {
        this.sendMessage(Identity.nil(), message, type);
    }

    default public void sendMessage(@NonNull Identified source, @NonNull Component message, @NonNull MessageType type) {
        this.sendMessage(source.identity(), message, type);
    }

    default public void sendMessage(@NonNull Identity source, @NonNull Component message, @NonNull MessageType type) {
    }

    default public void sendActionBar(@NonNull ComponentLike message) {
        this.sendActionBar(message.asComponent());
    }

    default public void sendActionBar(@NonNull Component message) {
    }

    default public void sendPlayerListHeader(@NonNull ComponentLike header) {
        this.sendPlayerListHeader(header.asComponent());
    }

    default public void sendPlayerListHeader(@NonNull Component header) {
        this.sendPlayerListHeaderAndFooter(header, Component.empty());
    }

    default public void sendPlayerListFooter(@NonNull ComponentLike footer) {
        this.sendPlayerListFooter(footer.asComponent());
    }

    default public void sendPlayerListFooter(@NonNull Component footer) {
        this.sendPlayerListHeaderAndFooter(Component.empty(), footer);
    }

    default public void sendPlayerListHeaderAndFooter(@NonNull ComponentLike header, @NonNull ComponentLike footer) {
        this.sendPlayerListHeaderAndFooter(header.asComponent(), footer.asComponent());
    }

    default public void sendPlayerListHeaderAndFooter(@NonNull Component header, @NonNull Component footer) {
    }

    default public void showTitle(@NonNull Title title) {
    }

    default public void clearTitle() {
    }

    default public void resetTitle() {
    }

    default public void showBossBar(@NonNull BossBar bar) {
    }

    default public void hideBossBar(@NonNull BossBar bar) {
    }

    default public void playSound(@NonNull Sound sound) {
    }

    default public void playSound(@NonNull Sound sound, double x, double y, double z) {
    }

    default public void stopSound(@NonNull SoundStop stop) {
    }

    default public void openBook(@NonNull Book.Builder book) {
        this.openBook(book.build());
    }

    default public void openBook(@NonNull Book book) {
    }
}

